function seeds = RS_SeedSrot(ns,method,degrees)
%
% function seeds = RS_SeedSrot(ns,method,degrees)
%
% e.g.: seeds = seed_srot(ns,'normal',5)
%
% Assigns random values by which stress tensors will be rotated to give
% stresses at seed points
%
% INPUTS:   ns = number of seed points
%           method = 'normal' or 'uniform'
%           degrees = std (normal) or range (uniform) degrees of stress
%           rotation (both azimuth and inclination).
%
% OUTPUTS:  seeds = ns x 3 vector listing the Euler angles of
%               stress rotation
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


seeds = NaN(ns,3);

if strcmpi(method,'normal')
    
    seeds(:,1) =  degrees(1)*(randn(1,ns));
    if length(degrees) == 3
        seeds(:,2) =  degrees(2)*(randn(1,ns));
        seeds(:,3) =  degrees(3)*(randn(1,ns));
    else
        seeds(:,2) =  degrees(1)*(randn(1,ns));
        seeds(:,3) =  degrees(1)*(randn(1,ns));
    end
        
    
elseif strcmpi(method,'uniform')
    
    seeds(:,1) =  2*degrees(1)*(0.5-rand(1,ns));
    if length(degrees) == 3
        seeds(:,2) =  2*degrees(2)*(0.5-rand(1,ns));
        seeds(:,3) =  2*degrees(3)*(0.5-rand(1,ns));
    else
        seeds(:,2) =  2*degrees(1)*(0.5-rand(1,ns));
        seeds(:,3) =  2*degrees(1)*(0.5-rand(1,ns));
    end
    

else
    fprintf('%s \n',['seed_points: method ',method,' not recognised']);    
end
