function seeds = RS_SeedSmod(ns,method,percent)
%
% function seeds = RS_SeedSmod(ns,method,percent)
%
% e.g.: seeds = seed_smod(ns,'normal',10)
%
% Assigns random values by which stresses will be geomechanical stresses 
% will be modulated
%
% INPUTS:   ns = number of seed points
%           method = 'normal' or 'uniform'
%           percent = std (normal) or range (uniform) percentage stress
%           modulation
%
% OUTPUTS:  seeds = ns x 3 vector listing the stress modulation factor for
%                   each seed for S1, S2 and S3
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


seeds = NaN(ns,3);

if strcmpi(method,'normal')
    
    seeds(:,1) =  percent*(randn(1,ns));
    seeds(:,2) =  percent*(randn(1,ns));
    seeds(:,3) =  percent*(randn(1,ns));

elseif strcmpi(method,'uniform')
    
    seeds(:,1) =  2*percent*(0.5-rand(1,ns));
    seeds(:,2) =  2*percent*(0.5-rand(1,ns));
    seeds(:,3) =  2*percent*(0.5-rand(1,ns));

else
    fprintf('%s \n',['seed_points: method ',method,' not recognised']);    
end
