function [xs,ys,zs] = RS_SeedPoints(ns,method,vector,varargin)
%
% function [xs,ys] = RS_SeedPoints(ns,method,vector)
%
% e.g.: [xs,ys] = seed_points(30000,'uniform',[minx maxx miny maxy])
%                   OR
%       [xs,ys] = seed_points(30000,'normal',[meanx stdx meany stdy])
%
% Generates ns random seed points for geomechanics-induced microseismicity
% predictions. Seeds can either be uniformly distributed within a given
% volume, or normally distributed with a given mean and std
%
% INPUTS:   ns = number of seed points
%           method = select to use a uniform or normal distribution
%           vector = numbers that describe either the volume of interest
%           (for uniform distribution) or the mean and std (for normal
%           distribution)
%
% OUTPUTS:  seeds = 2 x ns vector listing the x and y coordinates of the
%           seed points
%
% Written by J.P. Verdon, 2014
% University of Bristol
%



if strcmpi(method,'normal')
    error('Havent done normal yet, try uniform instead')

elseif strcmpi(method,'uniform')
    
    xs = vector(1) + rand(ns,1) * (vector(2) - vector(1));
    ys = vector(3) + rand(ns,1) * (vector(4) - vector(3));
    if nargout > 2
        zs = vector(5) + rand(ns,1) * (vector(6) - vector(5));
    end

elseif strcmpi(method,'density')
    density = importdata(vector);
    dx = density(:,1);
    dy = density(:,2);
    if nargout > 2
        dz = density(:,3);
    end
    denraw = density(:,4);
    
    iexit = 0;
    den = denraw;
        
    fmult = 1;
    while sum(den(:)) < ns
        den=denraw*fmult;
        fmult = fmult+10;
    end
    
    
    thresh=max(den);
    while iexit < 1
        thresh = thresh-0.1;
        highvals = find( den>thresh );
    
        s = round(den(highvals));
        n = sum(s);

        if n > ns || thresh < 0
            break
        end
    end
    
    dxnode = varargin{1};
    dynode = varargin{2};
    if nargout > 2
        dznode = varargin{3};
    end
    
    c = 1;
    xs = zeros(1,n);
    ys = xs;
    for i = 1:length(s)
        xs(c:c+s(i)-1) = (rand(1,s(i)) - 0.5)*dxnode + dx(highvals(i));
        ys(c:c+s(i)-1) = (rand(1,s(i)) - 0.5)*dynode + dy(highvals(i));
        if nargout > 2
            zs(c:c+s(i)-1) = (rand(1,s(i)) - 0.5)*dznode + dz(highvals(i));
        end
        c = c+s(i);
    end


    
else
    fprintf('%s \n',['seed_points: method ',method,' not recognised']);    
end
    