% function Mout = MoMw(Min,type)
%
% % Convert Mo to Mw, or vice-versa. Type determines which way to convert -
% type = 'Mw' means convert Mw to Mo
% type = 'Mo' means the opposite
%

function Mout = MoMw(Min,type)

if strcmp(type,'Mo')
    Mout = (2/3)*(log10(Min) - 9.1);
elseif strcmp(type,'Mw')
    Mout = 10.^(1.5*Min + 9.1);
else
    error(['Type ',type,' not recognised'])
end
