%---------------------------------------------------------
% fspline_curve
%---------------------------------------------------------
% calculate the curvature of cubic b-spline defined in
% constable and parker 1997
%
% input: 	i	spline number (i=1 for first spline)
%		x	x value
%		s	starting x value of the dataset	
%		k	knot spacing
% output:	y	spline curvature  d2y/dt2 at t(x)
%
%---------------------------------------------------------
% N.Teanby	17/01/07
% N.Teanby	06/04/09	output curv changed from d2y/dt2 to d2y/dx2
%---------------------------------------------------------
function [y] = fspline_curv(i,x,s,k)

t=(x-s)/k - (i - 2);

if t < -2
  y=0;
elseif t < -1
  y=6*(t+2);
elseif t < 0
  y= -12 - 18*t;
elseif t < 1
  y= -12 + 18*t;
elseif t < 2
  y= 6*(2-t);
else
  y=0;
end

% convert d2y/dt2 to d2y/dx2
y = y/(k*k);
