%---------------------------------------------------------
% fspline
%---------------------------------------------------------
% calculate the value of cubic b-spline defined in
% constable and parker 1997
%
% input: 	i	spline number (i=1 for first spline)
%		x	x value
%		s	starting x value of the dataset	
%		k	knot spacing
% output:	y	spline value at t(x)
%
%---------------------------------------------------------
% N.Teanby	17/01/07
%---------------------------------------------------------
function [y] = fspline(i,x,s,k)

t=(x-s)/k - (i - 2);

if t < -2
  y=0;
elseif t < -1
  y=(t+2)^3;
elseif t < 0
  y= 4 - 6*t^2 - 3*t^3;
elseif t < 1
  y= 4 - 6*t^2 + 3*t^3;
elseif t < 2
  y= (2-t)^3;
else
  y=0;
end
