%---------------------------------------------------------
% fspline_grad
%---------------------------------------------------------
% calculate the gradient of cubic b-spline defined in
% constable and parker 1997
%
% input: 	i	spline number (i=1 for first spline)
%		x	x value
%		s	starting x value of the dataset	
%		k	knot spacing
% output:	y	spline gradient  dy/dt at t(x)
%
%---------------------------------------------------------
% N.Teanby	17/01/07
% N.Teanby	06/04/09	output grad changed from dy/dt to dy/dx
%---------------------------------------------------------
function [y] = fspline_grad(i,x,s,k)

t=(x-s)/k - (i - 2);

if t < -2
  y=0;
elseif t < -1
  y=3*(t+2)^2;
elseif t < 0
  y= -12*t - 9*t^2;
elseif t < 1
  y= -12*t + 9*t^2;
elseif t < 2
  y= -3*(2-t)^2;
else
  y=0;
end

% convert dy/dt to dy/dx
y = y/k;
