;-----------------------------------------------------------------------
pro zreaddata,filename,dataset
;-----------------------------------------------------------------------
;
; read in a 3 column data file containing (lon,lat,f)
;
; also calculates the cartesian coords of the datapoints
;
;-----------------------------------------------------------------------
;   N. Teanby   6-01-06    Original Code
;-----------------------------------------------------------------------

; count number of lines in the file
nlines,filename,n

; read in the data
dat = fltarr(3,n)
openr,1,filename
readf,1,dat
close,1

; assign arrays
lon = dat(0,*)
lat = dat(1,*)
f   = dat(2,*)

; convert to cartesians
zlonlat2xyz,lon,lat,n,x,y,z

; define the data structure
dataset = {n:n,lon:lon,lat:lat,f:f,x:x,y:y,z:z}

return
end
