;-----------------------------------------------------------------------
pro zlonlat2xyz,lon,lat,n,x,y,z
;-----------------------------------------------------------------------
;
; Program to convert longitude and latitude into cartesian coords
; for a sphere
;
; in:
;    lon/lat    flatarr(n)  grids of latitude and longitude
;    n          int         number of lat/long points
; out:
;    x/y/z      fltarr(n)   cartesian coords         
;
;
;
;-----------------------------------------------------------------------
;   N. Teanby   6-01-06    Original Code
;-----------------------------------------------------------------------
pi=3.141592654
deg2rad=pi/180.

; calc cartesian coords
x = fltarr(n)
y = fltarr(n)
z = fltarr(n)
for i=0,n-1 do begin
  latrad = lat(i)*deg2rad
  lonrad = lon(i)*deg2rad
  x(i) = cos(latrad)*cos(lonrad)
  y(i) = cos(latrad)*sin(lonrad)
  z(i) = sin(latrad)
endfor  


return
end
