;-----------------------------------------------------------------------
pro zicosbin,lon,lat,f,n,x,y,z,$
longrid,latgrid,xgrid,ygrid,zgrid,nbins,c,ibin,$
lonave,latave,fave,nave
;-----------------------------------------------------------------------
;
; calc average lon/lat/f value for the ibin_th bin
;
; must run ztesselation_varstep and ztriangulate first as output
; from these routines are required as inputs
;
;input variables
; lon       longitudes of datapoints
; lat       latitudes of datapoints
; f         value of dependant variable at lon/lat
; n         number of datapoints
; x/y/z     cartesian coords of datapoints
;
; longrid   longitudes of bin centres
; latgrid   latitudes of bin centres
; x/y/zgrid cartesian coords of bin centres
; nbins     number of bins
; c         connectivity of bins
; ibin      bin number to calc output for
;
;output variables
; lonave    average longitude of the ibin_th bin
; latave    average latitude of the ibin_th bin
; fave      average value pf the dependant variable for the ibin_th bin
; nave      number of datapoints that went into the average
;
;-----------------------------------------------------------------------
;   N. Teanby   19-09-05    Original Code
;-----------------------------------------------------------------------
pi=3.141592654
deg2rad=pi/180.

; define bin polygon and bin midpoint
m = c[ibin].m ; number of vertices in polygon
polylon=fltarr(m)
polylat=fltarr(m)
index = c[ibin].con(0:m-1)
polylon = longrid(index)
polylat = latgrid(index)
polyx   = xgrid(index)
polyy   = ygrid(index)
polyz   = zgrid(index)
mlon    = longrid(ibin)
mlat    = latgrid(ibin)
mx      = xgrid(ibin)
my      = ygrid(ibin)
mz      = zgrid(ibin)

; decide which data points are in this bin
select_forbin = intarr(n)
for j=0L,n-1 do begin
   inside = finsides(lon(j),lat(j),x(j),y(j),z(j),$
                     polylon,polylat,polyx,polyy,polyz,m,$
                     mlon,mlat,mx,my,mz)
   if (inside eq 1) then begin
      select_forbin(j)=1
   endif else begin
      select_forbin(j)=0
   endelse
endfor

; average the values in this bin
x1 = 0.
y1 = 0.
z1 = 0.
lonave = 0.
latave = 0.
fave   = 0.
nave   = 0L
for j=0L,n-1 do begin
  if (select_forbin(j) eq 1) then begin
    x1 = x1 + x(j)
    y1 = y1 + y(j)
    z1 = z1 + z(j)
    fave = fave + f(j)
    nave = nave + 1
  endif
endfor
; only calc average if >= 1 datapoints in the bin
if nave gt 0 then begin
  x1 = x1/float(nave)
  y1 = y1/float(nave)
  z1 = z1/float(nave)
  lonave = atan(y1,x1)/deg2rad
  ; output longitude in 0-360 range
  if (lonave lt 0) then begin
    lonave = lonave + 360.
  endif
  latave = atan(z1,sqrt(x1*x1 + y1*y1))/deg2rad
  fave = fave/float(nave)
endif


return
end

