;-----------------------------------------------------------------------
; binrect.pro
;-----------------------------------------------------------------------
; IDL program to make a synthetic dataset
; for testing binning methods
; 
; program requires no user input.
;
;-----------------------------------------------------------------------
;   N. Teanby   28-09-05    Original Code
;-----------------------------------------------------------------------
deg2rad = 0.017453292

; synthetic data structure
; obs1 is one observation of value f
; x and y are in spacecraft frame (range is -1 to +1)
; lat and long are if spacecraft is looking down on the north pole
obs1 = {x:0.,y:0.,lat:0.,lon:0.,ondisk:0,f:0.}

; output files
outfilexy = 'synth.xy'  ; x y coordinates only (spacecraft frame)
outfile   = 'synth.dat' ; lon,lat,f in geographic coordinates

; seed for random noise and noise level
iseed = -666
noiselevel = 0.5

; spacing of the observations in the spacecraft frame
dx = 0.025
dy = 0.025

; number of observations
nx = 2/dx + 1
ny = 2/dy + 1
n = nx*ny

; create synthetic observations according to:
; f = lat/90. + noise
obs = replicate(obs1,n)
for i=0,nx-1 do begin
  for j=0,ny-1 do begin
    k = i*nx + j
    x = -1.0 + i*dx
    y = -1.0 + j*dy
    r = sqrt(x*x + y*y)
    if r le 1 then begin
      obs[k].ondisk = 1
      lon = atan(y,x) / deg2rad
      if (lon lt 0.) then begin
        lon = lon + 360.
      endif
      lat = acos(r)   / deg2rad
      obs[k].lat = lat
      obs[k].lon = lon
      ; f is some latitude dependent function + noise
      obs[k].f   = lat/90. + randomn(iseed)*noiselevel
    endif
    obs[k].x   = x
    obs[k].y   = y
  endfor
endfor

; write output
openw,1,outfile
for k=0,n-1 do begin
  if (obs[k].ondisk eq 1) then begin
    printf,1,obs[k].lon,obs[k].lat,obs[k].f
  endif
endfor
close,1

; write output
openw,1,outfilexy
for k=0,n-1 do begin
  printf,1,obs[k].x,obs[k].y
endfor
close,1

end

    
    
    
    
