;-----------------------------------------------------------------------
;pro plotxyz
;-----------------------------------------------------------------------
;
; read in lon,lat,z data and plot using filled contours
;
;-----------------------------------------------------------------------
; N. Teanby 26-9-05  Original
;-----------------------------------------------------------------------
device, retain=2, decomposed=0
nlevels    = 20
clatitude  = 90
clongitude = 0
proj       = 2 ; othographic

; input file
infile  = 'synth.bin_icos'
;infile  = 'synth.bin_rect'

; read in the data
nlines,infile,n
data = fltarr(3,n)
openr,1,infile
readf,1,data
close,1
x = data(0,*)
y = data(1,*)
z = data(2,*)

; plot basemap 
map_set, clatitude, clongitude, proj=proj, /grid, $
	      latdel=10, londel=30, /horizon, glinestyle=0, /label,$
            title=infile,position=[0.1,0.1,0.9,0.9],/isotropic

; set contour levels
zmin=-1.2
zmax= 1.2
levels=zmin + findgen(nlevels)*(zmax-zmin)/(nlevels-1)

; do contouring
c_colors=indgen(nlevels)
loadct, 33, ncolors=nlevels
contour,z,x,y,$
levels=levels,$
/fill,c_colors=c_colors,/overplot,$
/irregular,position=[0.1,0.1,0.9,0.9]

; switch back to BW for grid
loadct, 0
; plot data points
plots,x,y,psym=1,symsize=0.25
; overlay grid
map_set, clatitude, clongitude, proj=proj, /grid, $
	      latdel=10, londel=30, /horizon, glinestyle=0,$
            /label,/noerase,position=[0.1,0.1,0.9,0.9],$
            /isotropic,title=infile

;scalebar
loadct, 33, ncolors=nlevels
zs=[levels,levels]
xs=[fltarr(nlevels),fltarr(nlevels)+1]
ys=zs
contour,zs,xs,ys,levels=levels,/fill,c_colors=c_colors,/irregular,/noerase,position=[0.95,0.3,0.99,0.7],xstyle=4,ystyle=9,yrange=[zmin,zmax]

end


