;-----------------------------------------------------------------------
; binrect.pro
;-----------------------------------------------------------------------
; IDL program to perform conventional rectangular binning binning.
; 
; program requires no user input.
;
; required subroutines and functions:
;  nlines.pro                   counts number of lines in a file
;  fangular_sep.pro             determine angular separation between two vectors
;
;-----------------------------------------------------------------------
;   N. Teanby   28-09-05    Original Code
;-----------------------------------------------------------------------
deg2rad = 0.017453292

infile  = 'synth.dat'
outfile = 'synth.bin_rect'

; bin width in lat and lon
wlat = 18. 
wlon = 18.

; read in data
nlines,infile,n
data = fltarr(3,n)
openr,1,infile
readf,1,data
close,1
lon = data(0,*)
lat = data(1,*)
f   = data(2,*)

; calc spacing of bins (divide by 2 for nyquist spacing)
dlat = wlat/2.
dlon = wlon/2.

; calc number of bins
nlat = round(180./dlat)-1
nlon = round(360./dlon)
nbins=nlat*nlon 

; set up a structure of bin parameters
singlebin = {latmin:0.,latmax:0.,lonmin:0.,lonmax:0.}
bins = replicate(singlebin,nbins)
; assign the lat/lon ranges to each bin in the structure
for i=0,nlat-1 do begin
  for j=0,nlon-1 do begin
    k = i*nlon + j
    bins[k].lonmin = j*dlon
    bins[k].lonmax = bins[k].lonmin + wlon ;this may be slightly over 360!
    bins[k].latmin = -90. + i*dlat
    bins[k].latmax = bins[k].latmin + wlat
  endfor
endfor

; perform the binning
lonave = fltarr(nbins)
latave = fltarr(nbins)
fave = fltarr(nbins)
nave = intarr(nbins)
openw,2,outfile
for i=0L,nbins-1 do begin
  print,'bin ',i+1,' of ',nbins
  select_forbin = intarr(n)
  clon_bin = (bins[i].lonmin+bins[i].lonmax)/2.; this is ok as lon = 0-360
  pos_bin =[cos(clon_bin*deg2rad),sin(clon_bin*deg2rad)]
  ; decide which data points are in this bin
  for j=0L,n-1 do begin
     if (lat(j) lt bins[i].latmin) then begin
       goto,label1
     endif
     if (lat(j) gt bins[i].latmax) then begin
       goto,label1
     endif
     ; calc longitude separation of data point from bin centre
     pos_spec = [cos(lon(j)*deg2rad),sin(lon(j)*deg2rad)]
     if (fangular_sep(pos_bin,pos_spec) gt dlon) then begin
       goto,label1
     endif
     select_forbin(j) = 1
     label1:
  endfor
  ; average the values in this bin
  x1 = 0.
  y1 = 0.
  z1 = 0.
  for j=0L,n-1 do begin
    if (select_forbin(j) eq 1) then begin
      x1 = x1 + cos(lat(j)*deg2rad)*cos(lon(j)*deg2rad)
      y1 = y1 + cos(lat(j)*deg2rad)*sin(lon(j)*deg2rad)
      z1 = z1 + sin(lat(j)*deg2rad)
      fave(i) = fave(i) + f(j)
      nave(i) = nave(i) + 1
    endif
  endfor
  if nave(i) gt 0 then begin
    lonave(i) = atan(y1,x1)/deg2rad
    ; output longitude in 0-360
    if (lonave(i) lt 0) then begin
      lonave(i)=lonave(i)+360.
    endif
    latave(i) = atan(z1,sqrt(x1*x1 + y1*y1))/deg2rad
    fave(i) = fave(i)/float(nave(i))
    printf,2,lonave(i),latave(i),fave(i)
;;    printf,2,lonave(i),latave(i),fave(i),nave(i)
  endif
endfor

close,2

end


