;-----------------------------------------------------------------------
; binicos.pro
;-----------------------------------------------------------------------
; IDL program to illustrate subdivided icosahedral binning.
; 
; program requires no user input.
; program reads in data from synth.dat
;
; required subroutines and functions:
;  zread data.pro               reads in datafile
;    nlines.pro                 counts number of lines in a file
;    zlonlat2xyz.pro            converts lat/lon to cartesian coords
;  ztesselation_varstep.pro     tesselates the sphere
;  ztriangulate.pro             triangulates the bin centres
;  zlonlat2xyz.pro              converts lat/lon to cartesian coords
;  zicosbin.pro                 bins the data
;    finsides.pro               determine if point is inside spherical polygon
;
;-----------------------------------------------------------------------
;   N. Teanby   19-09-05    Original Code
;-----------------------------------------------------------------------

; mode determines the starting polyhedron
; mode = 20: icosahedron
; mode =  8: octahedron (less accurate)
mode=20

; number of subdivisions to perform (0 is no subdivisions)
icoslevel=3

; sequence of steps for the subdivisions (2 is default here
; for bisection but 3 and 5 are also valid). Changing the 
; step allows greater flexibility for the final bin size.
step = [2,2,2,2,2]

; input and output files
infile  = 'synth.dat'
outfile = 'synth.bin_icos'

; read in the data into structure 'dataset'
zreaddata,infile,dataset

; tesselate the sphere
ztesselation_varstep,mode,icoslevel,step,longrid,latgrid,nbins

; triangulate and return the connectivity c
ztriangulate,longrid,latgrid,nbins,c

; convert long/lat into cartesians
zlonlat2xyz,longrid,latgrid,nbins,xgrid,ygrid,zgrid

; perform the binning and write output
openw,2,outfile
for ibin=0L,nbins-1 do begin
  print,'bin ',ibin+1,' of ',nbins
  zicosbin,dataset.lon,dataset.lat,dataset.f,dataset.n,$
             dataset.x,dataset.y,dataset.z,$
           longrid,latgrid,xgrid,ygrid,zgrid,nbins,c,ibin,$
           lonave,latave,fave,nave
  if nave gt 0 then begin
    printf,2,lonave,latave,fave,format='(f10.4,2x,f10.4,2x,f10.4)'
  endif
endfor
close,2

end


