function [asp,xi,xibc]=VK_cd_misfit(alpha,P,nu,mu,nsets)
%
% [asp,xi]=cd_misfit(alpha,nu,mu,nsets);
%
% Computes the best fitting initial crack density and aspect ratio to model
% an empirical crack-density ditribution
%
%

% Hardwire the search grid
dxi=0.005;
dasp=0.0001;
aspin=0.00001;
nxi=200;
nasp=100;

gxi=0:dxi:(nxi-1)*dxi;
gasp=0:dasp:(nasp-1)*dasp;
gasp(1)=aspin;
restot=NaN(nxi,nasp);

for i=1:nsets
    for j=1:nxi
        for k=1:nasp
            
            restot(j,k)=0.0;
            
            for l=1:length(P)
                    
                cr=2*(1-nu(i))/(pi*mu(i)*gasp(k));
				xi_m=gxi(j)*exp(-cr*P(l));
                
                res=(xi_m-alpha(l,i))*(xi_m-alpha(l,i));
                
                restot(j,k)=restot(j,k)+res;
            end
        end
    end
    imin=find(restot==(min(min(restot))));
    [tmp1,tmp2]=ind2sub(size(restot),imin);
    
    asp(i)=gasp(tmp2);
    xi(i)=gxi(tmp1);
    
    for l=1:length(P)
        cr=2*(1-nu(i))/(pi*mu(i)*asp(i));
	    xibc(l,i)=xi(i)*exp(-cr*P(l));
    end
end


                