function [strike,dip] = RS_SeedAngles(ns,method,vector)
%
% function [strike,dip] = RS_SeedAngles(ns,method,vector)
%
% e.g.: [strike,dip] = seed_angles(30000,'normal',[])
%                       OR
%       [strike,dip] = seed_angles(30000,'normal',[mean_ax std_az mean_inc std_inc])
%
% Generates ns random angles (strike and dip) of seed points. Angles can be
% random or normally distributed
%
% Angles are:   strike from 0 (N)  to 179 (S),
%               dip from 0 (up) to 179 (down)
%
% INPUTS:   ns = number of seed points
%           method = 'uniform' or 'normal'
%           vector = defines the mean and std of the normally distributed
%                    strikes and dips
%
% OUTPUTS:  [strike,dip] = ns x 2 vector listing the seed point strikes and dips
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


if strcmpi(method,'full')

    strike = rand(ns,1) * (359);
    dip = rand(ns,1) * (89);

elseif strcmpi(method,'normal')
    
    strike = vector(1) + vector(2)*randn(ns,1);
    dip = vector(3) + vector(4)*randn(ns,1);

        
elseif strcmpi(method,'uniform')
    
    strike = vector(1) + rand(ns,1) * (vector(2) - vector(1));
    dip = vector(3) + rand(ns,1) * (vector(4) - vector(3));
    
else
    fprintf('%s \n',['seed_points: method ',method,' not recognised']);    
end


