% function seed = RS_Run(seed,gm)
% 
% Run the Random Seed calculations
%
% INPUTS:	seed = seed structure, as defined in RS_InitialiseSeeds
% 			gm = geomechanical structure
% 
% OUTPUTS:	seed = updated seed structure providing results
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


function seed = RS_Run(seed,gm)

nt = seed.nt;
ns = seed.ns;

for i = 1:nt
    
    fprintf('%s \n',['Processing timestep ',gm.label{i}])
  
    for j=1:ns
        
        % Specify the original stress tensor from model node
        SD = [gm.S11(seed.tag(j)) gm.S22(seed.tag(j)) gm.S33(seed.tag(j))]...
            -gm.P(seed.tag(j),i);
        
        So = [SD(1) 0 0 ; 0 SD(2) 0 ; 0 0 SD(3)];
        
        % Modulate and rotate the stress tensor   
        for k = 1:3
            So(k,k) = So(k,k) +So(k,k)*seed.smod(j,k)/100;
        end

        S = RS_EulerRotate(So,seed.srot(j,:));
        
        
        % Remove any previous stress drops
        for k = 1:i-1
             if seed.sheartag(j,k) == 1
                Sr=seed.R{j,k}'*S*seed.R{j,k};
                
                if k == 1 % If an event triggers during the initialisation 
                          % phase - take all shear stress away
                    Sr(1,2) = Sr(1,2) + seed.tau(j,i);
                else
                    Sr(1,2) = Sr(1,2) + seed.ds(j,k);
                end
                Sr(2,1) = Sr(1,2);
                
                S = seed.R{j,k}*Sr*seed.R{j,k}';
             end

        end
        
        % Resolve stresses into normal and shear on seed plane
        [seed.sn(j,i),seed.tau(j,i),rake,R] = RS_ResolveStress(S,...
            seed.str(j),seed.dip(j));
        
        
        % Determine shear failure criteria
        if seed.tau(j,i) > seed.sn(j,i)*seed.muf(j) + seed.cohesion(j)

            seed.sheartag(j,i)=1;
            
            seed.rake(j,i) = rake;
            
            seed.R{j,i} = R;
            
            seed.ds(j,i) = seed.tau(j,i)*rand*sdr;
            
            Area = pi*(seed.l(j)*seed.lmod(j)).^2;
            Mo = seed.ds(j,i).*(Area.^1.5);
            
            seed.mag(j,i) = MoMw(Mo,'Mo');
            
        end
            
    end 
                
end



