function [cm]=cumulative_magnitude(mbins,iinv)
%
% function [cm]=cumulative_magnitude(m)
%
% Computes the cumulative magnitude (as for b-value plot) given a
% population of seismic event magnitudes
%
% INPUTS	mbins - the vector of values for each bin
%			iinv - direction of calculation: 0 for forward (compute
%				cdf given distribution, 1 for inverse (compute 
%				distribution given a cdf)
%
% OUTPUTS	cm - the resulting cdf (or distribution) vector
%
% Written by J.P. Verdon, University of Bristol, 2012
%



if ~exist('iinv','var')
    iinv = 0;
end

if iinv == 0
    cm=zeros(1,length(mbins));
    for j=1:length(mbins)  
        cm(j)=sum(mbins(j:end));
    end
    
    
elseif iinv == 1
    cm=zeros(1,length(mbins));
    for j=1:length(mbins)-1
        cm(j)=mbins(j)-mbins(j+1);
    end
    cm(end)=mbins(end);
    
else
    error('Cumulative magnitude method not recognised')
end





