clear

% Load in the microseismic event times and magnitudes
A = load('MicroseismicData.dat');
ET = A(:,1);  EM = A(:,5);

% Times are in hours of the day
time = 7.5:0.1:16;  % Define a time axis, at which times calculations will be made

% Load in injection rates
B = load('InjectionData.dat');
IT = B(:,1);
IR = B(:,2);  % IR is barrels/min, listed every second
IR = IR*0.159/60;  % Convert injection rates to m3/s
Vmax = sum(IR);  % Vmax is the total injected volume at the end of the stage

% Initialise the various parameters
MmaxHallo = NaN(length(time),1);
MmaxShap = NaN(length(time),1);
b = NaN(length(time),1);
Seff = NaN(length(time),1);
SI = NaN(length(time),1);
MC = NaN(length(time),1);
IC = NaN(length(time),1);

% Run PredictMmax at each timestep
for i = 1:length(time)
    [MmaxHallo(i),MmaxShap(i),Seff(i),b(i),SI(i),MC(i),IC(i)] = ...
        PredictMmax(EM(ET<=time(i)),ET(ET<=time(i)),...
        IR(IT<=time(i)),IT(IT<=time(i)),Vmax,'nmin',30,'E',0.05,'G',20e9,'rounded',false);
   
end

% Plot the results
PredictMmaxPlot(EM,ET,MmaxHallo,MmaxShap,Seff,SI,b,time,'maglim',[-2.5 0.5],...
    'blim',[0 4])





