!***************************************************************************************************
subroutine output
!---------------------------------------------------------------------------------------------------
!
! Subroutine OUTPUT writes the best fit model to screen, writes the resulting elastic stiffness 
! tensor to file,
!
! Other subroutines called:
!    Uses insaff_globals to access global parameters
!    Uses insaff_lib to access writing subroutines, and elastic stiffness operations
!    Makes calls direct to shell
!
!***************************************************************************************************


use insaff_globals
use insaff_lib

implicit none
integer			:: i,j,unit
real			:: eps,c(6,6)


! Get the final stiffness tensor
select case (rp)
	case (1)
		c=cvti(vpi,vsi,rho,finalmodel(1),finalmodel(2),finalmodel(3))
	case (2)
		c=cvtifrac(vpi,vsi,rho,finalmodel(1),finalmodel(2),epsi,gami,deli)
	case (3)
		c=cdipfr(vpi,vsi,rho,finalmodel(1),finalmodel(2),finalmodel(3),epsi,gami,deli)
	case (4)
		c=cdfrac(vpi,vsi,rho,finalmodel(1),finalmodel(2),finalmodel(3),finalmodel(4),epsi,gami,deli)
	case (5)					
		c=cvtifrac(vpi,vsi,rho,finalmodel(1),finalmodel(2),finalmodel(3),finalmodel(4),finalmodel(5))
	case (6)
		c=cvtifrac_znzt(vpi,vsi,rho,finalmodel(1)*finalmodel(2),finalmodel(1),finalmodel(3),epsi,gami,deli)
	case (7)
		c=cdipfr(vpi,vsi,rho,finalmodel(1)*finalmodel(2),finalmodel(1),finalmodel(3),epsi,gami,deli)
	case (8)					
		c=cvtifrac_znzt(vpi,vsi,rho,finalmodel(1)*finalmodel(2),finalmodel(1),finalmodel(3),finalmodel(4),&
			finalmodel(5),finalmodel(6))
	
end select

! Write summary to screen
call write_to_screen(finalmodel,rp)

if (lo.gt.0)then
	write(6,*)' --> Writing stiffness tensor to file ',ofile(1:lo),'.cij'
	open(10,file=ofile(1:lo)//'.cij',form='formatted')
	do i = 1,6
		write(10,*)(c(i,j),j=1,6)
	enddo
	close(10)
	!unit = 11
	write(6,*)' --> Writing results summary to file ',ofile(1:lo),'.out'
	open(10,file=ofile(1:lo)//'.out',form='formatted')
	call write_na_summary(10)
	!write(10,*)'hg1=',h(1)
	!close(10)
endif




end subroutine output
!***************************************************************************************************


!***************************************************************************************************
subroutine write_na_summary(unit)
!---------------------------------------------------------------------------------------------------
!
! Subroutine WRITE_NA_SUMMARY writes summary information from the insaff_na inversion
!
! Information written includes:
!    vpi,vsi,epsi,gami,deli = initial, fixed parameters
!    ranges = maximum and minimum parameter ranges
!    model = best fit model
!    lb = axis labels for plotting
!
!    Information is written to file identified by unit
!
! Written by J.P. Verdon, University of Bristol, 2008-2011
!
!***************************************************************************************************
use insaff_globals
use io_lib
implicit none

integer					:: unit,i,lsc
character*256			:: syscommand

write(unit,*)'% Input Parameters'
write(unit,101)'VPI=',vpi
write(unit,101)'VSI=',vsi
write(unit,101)'RHO=',rho
write(unit,100)'GAM=',gami
write(unit,100)'EPS=',epsi
write(unit,100)'DEL=',deli
write(unit,102)'NRP=',rp
write(unit,102)'NFP=',np
write(unit,*)'SETUP=',settype(1:lst)

write(unit,*)
write(unit,*)'% Parameters and Ranges'
select case (rp)
	case (1)
		write(unit,'(A9)')'PA1=GAMMA'
		write(unit,'(A9)')'PA2=DELTA'
		write(unit,'(A11)')'PA3=EPSILON'
		
	case (2)
		write(unit,'(A12)')'PA1=FRACDENS'
		write(unit,'(A10)')'PA2=STRIKE'
	
	case (3)
		write(unit,'(A12)')'PA1=FRACDENS'
		write(unit,'(A10)')'PA2=STRIKE'
		write(unit,'(A7)')'PA3=DIP'
		
	case (4)
		write(unit,'(A14)')'PA1=FRACDENS_1'
		write(unit,'(A12)')'PA2=STRIKE_1'
		write(unit,'(A14)')'PA3=FRACDENS_2'
		write(unit,'(A12)')'PA4=STRIKE_2'

	case (5)
		write(unit,'(A12)')'PA1=FRACDENS'
		write(unit,'(A10)')'PA2=STRIKE'
		write(unit,'(A7)')'PA3=EPS'
		write(unit,'(A9)')'PA4=GAMMA'
		write(unit,'(A9)')'PA5=DELTA'
		
	case (6)
		write(unit,'(A6)')'PA1=ZT'
		write(unit,'(A8)')'PA2=ZNZT'
		write(unit,'(A10)')'PA3=STRIKE'
		
	case (7)
		write(unit,'(A6)')'PA1=ZT'
		write(unit,'(A8)')'PA2=ZNZT'
		write(unit,'(A10)')'PA3=STRIKE'
		write(unit,'(A7)')'PA3=DIP'
		
	case (8)
		write(unit,'(A6)')'PA1=ZT'
		write(unit,'(A8)')'PA2=ZNZT'
		write(unit,'(A10)')'PA3=STRIKE'
		write(unit,'(A7)')'PA4=EPS'
		write(unit,'(A9)')'PA5=GAMMA'
		write(unit,'(A9)')'PA6=DELTA'
		
end select

write(unit,*)
do i = 1,np
	write(unit,103)'RA',i,'=',rng(1,i),',',rng(2,i)
enddo	

write(unit,*)
write(unit,*)'% Best Fit Model'
write(unit,*)(finalmodel(i),i=1,np)
		
write(unit,*)
write(unit,*)'% Associated files used/created'
write(unit,*)'CIJ=',ofile(1:lo)//'.cij'
write(unit,*)'DATA='//dfile(1:ld)
write(unit,*)'CFILE='//cfile(1:lc)
if (lnaf.gt.0)then
	write(unit,*)'NAD='//nafile(1:lnaf)
endif

! Create a matlab-generated result sphere
if (imsph(1:limsph).eq.'yes')then
	write(6,*)' --> Generating Matlab Sphere Plot:'
	syscommand = 'matlab -nosplash -nodesktop -r "INSAFF_SphereFromFortran '//ofile(1:lo)//'" > insaffmat.log'
	lsc = icharlen(syscommand)
	write(6,*)'       ',syscommand(1:lsc)
	!read(*,*)
	call system(syscommand(1:lsc))
	syscommand = 'open '//ofile(1:lo)//'.png'
	lsc = icharlen(syscommand)
	call system(syscommand(1:lsc))
endif

100 format(A4,F7.3)
101 format(A4,F7.1)
102 format(A4,I2)
103 format(A2,I1,A1,F7.3,A1,F7.3)

return
end subroutine write_na_summary
!***************************************************************************************************



