!***************************************************************************************************
! Module INSAFF_GLOBALS is used to define global parameters for insaff_na, as well as to store
! global variables
! 
! Written by J.P. Verdon, University of Bristol, 2008-2011
!***************************************************************************************************
module insaff_globals

implicit none

! Universal parameters
real,parameter					:: pi=3.1415926535897932
	  
! Parameters for maximum memory usage
integer,parameter				:: mpar=6   ! Maximum dimensions in the inversion
integer,parameter				:: msws=8000  ! Maximum number of SWS measurements 
integer							:: irevaz

! Input parameters
integer							:: rp,itype,nmeas,np,ndec,isettype

real							:: vpi,vsi,rho,gami,deli,epsi,finalmodel(mpar)
real							:: wfact,minmag,minpsi,minmf
real,dimension(2,mpar)			:: rng
real,dimension(msws)			:: az,inc,ofast,omag
real,dimension(3)				:: h

character*256					:: ofile,dfile,cfile,nafile,settype,imsph
integer							:: lo,ld,lc,lnaf,lst,limsph

end module insaff_globals

