function [models,nd,nm,ranges]=insaff_readnad(filename)
% function [models,nd,nm,ranges]=insaff_readnad(filename)
%
% e.g., function [models,nd,nm,ranges]=insaff_readnad('file.nad') 
%
% INSAFF_READNAD an NA direct access file, and generates a scatter plot of
% the models of the ensemble (coloured by their misift)
% 
% INPUTS: filename=name of the nad file
%
% OUTPUTS: returns the models as a matrix of form (parameter_1 ... parameter_n misfit)
%          nd = number of parameters in the inversion
%          nm = number of models generated in the ensemble
%          ranges = parameter ranges
%
% Written by J.P.Verdon, University of Bristol, 2011
%
% Reading NADA file header - this stage is a little ad-hoc. Watch for bugs. Assumption is that data
% is written by NA in 32-bit format (unsigned integers and floats)
% For unknown reason, sometimes n on line 35 needs an extra record to be
% read (nd+2), and there are nm-1 models on line 40.
%
% Am currently considering restructuring the whole NA DA file. Watch this space....
%

fid=fopen(filename);
n=fread(fid,1,'uint'); % Blank
nd=fread(fid,1,'uint'); % Number of dimensions in inversion
nm=fread(fid,1,'uint'); % Number of models created
n=fread(fid,1,'uint'); % Blank
n=fread(fid,1,'uint'); % Blank
nsampling=fread(fid,3,'uint'); % Sampling/resampling tunable parameters

ranges=fread(fid,2*nd,'float'); % Parameter ranges
ranges=reshape(ranges,2,nd); 

scales=fread(fid,nd+1,'float'); % Scales (1 is -1 (a tag in NA), rest are for parameters 1:n)

n=fread(fid,nd-1,'float'); % nd-1 blanks written by NA - this seems to be a bit funny sometimes and may need to be adjusted for the correct number of blanks. 

% Now read the model data
models=fread(fid,(nd+1)*nm,'float'); % Each record is model parameters 1:n, followed by misfit
size(models)
nd+1
nm
models=reshape(models,nd+1,nm)';




