
% Generate a synthetic fracture set model using EFFEV
frac = struct('type','znzt','den',0.15,'strike',155,'dip',0,'znzt',0.2);
CE = effev('fracture',frac,'vp',5000,'vs',2900,'rho',2700,'eps',0.1,'delta',0.1,'gamma',0.1);

% Generate 100 random angles through this stiffness tensor
az = rand(1,100)*360;
inc = rand(1,100)*90;

% Generate synthetic splitting
[pol,avs,vs1,vs2,vp] = MS_phasevels(CE/1e9,2700,inc,az);

% Generate a plot of the synthetic data
MS_plot(CE/1e9,2500,'plotmap',{'AVSPOL'},'sdata',az,inc,pol',avs');

% Write synthetic data to file
fid = fopen('SWS_Demo.dat','w');
for i = 1:100
    fprintf(fid,'%f %f %f %f \n',az(i),inc(i),pol(i),avs(i));
end
fclose(fid);

% Run INSAFF from the terminal
system('insaff controls=insaff.in data=SWS_Demo.dat output=demo nadafile=demo.nad matlabsphere=yes');

