
clear

% Note: EFFEV requires that the MSAT toolbox
% (https://www1.gly.bris.ac.uk/MSAT/) is available

% Store fracture parameters in a structure
frac1 = struct('type','znzt','den',0.1,'strike',70,'dip',10,'znzt',0.75);

% Store parameters for a second fracture set
frac2 = struct('type','hudsonlf','den',0.05,'strike',20,'dip',0);

% Ren effev to generate effective medium model
C = effev('vp',4000,'vs',2300,'eps',0.05,'gamma',0.05,'delta',0.05,'fracture',frac1,'fracture',frac2);

% Write the tensor to screen
for i = 1:6
    fprintf('%7.2f %7.2f %7.2f %7.2f %7.2f %7.2f \n',C(:,i)/1e9);
end

% Plot the resulting stiffness tensor
MS_plot(C/1e9,2500);  

