function test_suite = test_MS_norms
initTestSuite;
end

function test_MS_norms_olivine_lit
    % Test the olivine example in the paper gives the published results
    % Note that the decomposition is checked in test_MS_decomp
    
    % Published tensors... page 671
    C_ref = [ 192.0  66.0  60.0   0.0   0.0   0.0 ; ...
               66.0 160.0  56.0   0.0   0.0   0.0 ; ...
               60.0  56.0 272.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  60.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0  62.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  49.0 ];
    C_ort = [  16.0   0.0   2.0   0.0   0.0   0.0 ; ...
                0.0 -16.0  -2.0   0.0   0.0   0.0 ; ...
                2.0  -2.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  -1.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   1.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ];
    C_tet = [   3.0  -3.0   0.0   0.0   0.0   0.0 ; ...
               -3.0   3.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  -3.0 ];
    C_hex = [ -21.7   1.7  -9.3   0.0   0.0   0.0 ; ...
                1.7 -21.7  -9.3   0.0   0.0   0.0 ; ...
               -9.3  -9.3  77.3   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  -2.7   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0  -2.7   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0 -11.7 ];
    C_iso = [ 194.7  67.3  67.3   0.0   0.0   0.0 ; ...
               67.3 194.7  67.3   0.0   0.0   0.0 ; ...
               67.3  67.3 194.7   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  63.7   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0  63.7   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  63.7 ];
    C_tri = zeros(6,6);
    C_mon = zeros(6,6);
            
    % Calc norms
    P = MS_norms(C_ref,C_iso,C_hex,C_tet,C_ort,C_mon,C_tri);
    
    % Only some results are in the paper (page 671)
    % Check results - only know the answer to 1dp.
    assertElementsAlmostEqual(P(1), 0.793, 'absolute', 0.3);
    assertElementsAlmostEqual(P(2), 0.152, 'absolute', 0.3);
    assertElementsAlmostEqual((P(3)+P(4)), 0.055, 'absolute', 0.3);
    assertElementsAlmostEqual(P(5), 0.0, 'absolute', 0.3);
    assertElementsAlmostEqual(P(6), 0.0, 'absolute', 0.3);
end

function test_MS_norms_enst_lit
    % Test the olivine example in the paper gives the published results
    
    % Published tensors... page 671 - note types fixes in C_ort and C_hex
    % c.f. email exchange between Wookey and Browaeys
    C_ref = [ 225.0  54.0  72.0   0.0   0.0   0.0 ; ...
               54.0 214.0  53.0   0.0   0.0   0.0 ; ...
               72.0  53.0 178.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  78.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0  82.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  76.0 ];
    C_ort = [   5.5   0.0   9.5   0.0   0.0   0.0 ; ...
                0.0  -5.5  -9.5   0.0   0.0   0.0 ; ...
                9.5  -9.5   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  -2.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   2.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ];
    C_tet = [   3.4  -3.4   0.0   0.0   0.0   0.0 ; ...
               -3.4   3.4   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  -3.4 ];
    C_hex = [   5.9   0.0   5.1   0.0   0.0   0.0 ; ...
                0.0   5.9   5.1   0.0   0.0   0.0 ; ...
                5.1   5.1 -32.2   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0   3.6   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0   3.6   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0   3.0 ];
    C_iso = [ 210.2  57.4  57.4   0.0   0.0   0.0 ; ...
               57.4 210.2  57.4   0.0   0.0   0.0 ; ...
               57.4  57.4 210.2   0.0   0.0   0.0 ; ...
                0.0   0.0   0.0  76.4   0.0   0.0 ; ...
                0.0   0.0   0.0   0.0  76.4   0.0 ; ...
                0.0   0.0   0.0   0.0   0.0  76.4 ];
    C_tri = zeros(6,6);
    C_mon = zeros(6,6);
    
    % Calc norms
    P = MS_norms(C_ref,C_iso,C_hex,C_tet,C_ort,C_mon,C_tri);
    
    % Only some results are in the paper (page 671)
    % Check results - only know the answer to 1dp.
    assertElementsAlmostEqual(P(1), 0.908, 'absolute', 0.3);
    assertElementsAlmostEqual(P(2), 0.043, 'absolute', 0.3);
    assertElementsAlmostEqual((P(3)+P(4)), 0.049, 'absolute', 0.3);
    assertElementsAlmostEqual(P(5), 0.0, 'absolute', 0.3);
    assertElementsAlmostEqual(P(6), 0.0, 'absolute', 0.3);
end
            