function test_suite = test_MS_rotR
initTestSuite;
end

function test_MS_rotR_simple

  C_ol = [320.5000   68.1000   71.6000         0         0         0; ...
           68.1000  196.5000   76.8000         0         0         0; ...
           71.6000   76.8000  233.5000         0         0         0; ...
                 0         0         0   64.0000         0         0; ...
                 0         0         0         0   77.0000         0; ...
                 0         0         0         0         0   78.7000];
             
  I = [1 0 0 ; 0 1 0 ; 0 0 1];
  
  % Rotation by the identity matrix gives us back what we started with...
  assertElementsAlmostEqual(C_ol, MS_rotR(C_ol, I));
  
  % 90 degree rotation about the A axis can be done by hand...
  A = [1 0 0 ; 0 0 1; 0 -1 0];
  C_ol_A = [320.5000   71.6000   68.1000         0         0         0; ...
             71.6000  233.5000   76.8000         0         0         0; ...
             68.1000   76.8000  196.5000         0         0         0; ...
                   0         0         0   64.0000         0         0; ...
                   0         0         0         0   78.7000         0; ...
                   0         0         0         0         0   77.0000];
  assertElementsAlmostEqual(C_ol_A, MS_rotR(C_ol, A));
         
end