function [c]=VK_vtoc(v,rho)
%
% function [c]=vtoc(v,rho)
%
% Computes stiffness tensor from velocities
%
% Written by J.P. Verdon, 2012, University of Bristol
%
%

% Determine if isotropic or anisotropic
if length(v) == 2
    c(1,1)=v(1)*v(1)*rho;
    c(2,2)=v(1)*v(1)*rho;
    c(3,3)=v(1)*v(1)*rho;
    c(4,4)=v(2)*v(2)*rho;
    c(5,5)=v(2)*v(2)*rho;
    c(6,6)=v(2)*v(2)*rho;
    c(1,2)=c(1,1)-2*c(4,4);
    c(1,3)=c(1,2);
    c(2,3)=c(1,2);
    
    c=VK_symmetry2d(c,6);
    
elseif length(v) == 7
    c(1,1)=rho*v(1)*v(1);
    c(2,2)=rho*v(2)*v(2);
    c(3,3)=rho*v(3)*v(3);
    c(4,4)=rho*v(5)*v(5);
    c(5,5)=rho*v(6)*v(6);
    c(6,6)=rho*v(7)*v(7);
    
    tmp1=c(3,3)+c(4,4)-2.0*rho*v(4)*v(4);
    tmp2=c(1,1)+c(4,4)-2.0*rho*v(4)*v(4);

    c(1,3)=-c(4,4)+sqrt(tmp1*tmp2);
    c(2,3)=c(1,3);
    c(1,2)=c(1,1)-2*c(6,6);
    
    c=VK_symmetry2d(c,6);
    
else
    error('vtoc can only compute stiffness from 2 or 7 velocity measurements')
end
