function [vt,quality]=VK_velocity_tod_beta(xibc,znzt,sm,h,rho,vin,iso)
%
% function [vt,quality]=velocity_tod_beta(xibc,znzt,sm,hm,rho,vin,iso)
%
% Computes Tod velocities and assesses fit to observed velocities using the
% calculated initial aspect ratios and crack densities
%
%

for i=1:size(xibc,1);
    
    if iso == 1    
        a(1)=xibc(i,1)/h(1);
        
        a(2)=a(1) ; a(3) = a(1);
    
    elseif iso == 2
        a = xibc(i,:)./h;
    end
    
    av=mean(a);
    f=znzt(i)-1;
    
    c1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)-(sm(2,2)+a(2)+f*av)*(sm(3,3)+a(3)+f*av);
	c2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)-(sm(1,1)+a(1)+f*av)*(sm(3,3)+a(3)+f*av);
	c3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)-(sm(1,1)+a(1)+f*av)*(sm(2,2)+a(2)+f*av);
	c13=(sm(1,3)+f*av/3)*(sm(2,2) + a(2)+f*av)-(sm(1,2)+f*av/3)*(sm(2,3)+f*av/3);
	c44=(sm(4,4) + a(2) + a(3) + 4*f*av/3);
	c55=(sm(5,5) + a(1) + a(3) + 4*f*av/3);
	c66=(sm(6,6) + a(1) + a(2) + 4*f*av/3);
		
	d1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)*(sm(1,1) + a(1) + f*av);
	d2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,2) + a(2) + f*av);
	d3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)*(sm(3,3) + a(3) + f*av);
	d4=2*(sm(1,2)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,3)+f*av/3);
	d5=(sm(1,1)+a(1)+f*av)*(sm(2,2)+a(2)+f*av)*(sm(3,3)+a(3)+f*av);
		
	d=d1+d2+d3-(d4+d5);
		
	ct(1,1)=c1/d;
	ct(2,2)=c2/d;
	ct(3,3)=c3/d;
	ct(1,3)=c13/d;
	ct(4,4)=1/c44;
	ct(5,5)=1/c55;
	ct(6,6)=1/c66;
    
    ct=VK_symmetry2d(ct,6);
    
    [vt(i,:)]=VK_ctov(ct,rho);
    
end

if iso == 1
    mvp=mean(vt(:,1:4),2);
    mvs=mean(vt(:,5:7),2);
    clear vt
    vt(:,1)=mvp;
    vt(:,2)=mvs;
end
    
quality=100*(abs(vin - vt)./vin);