function [v]=VK_ctov(c,rho)
%
% v=ctov(c,rho);
%
% Determines 7 velocities P(x,y,z,45), S(yz,xz,xy), from a stiffness
% tensor and density
%
%

v(1)=sqrt(c(1,1)/rho);
v(2)=sqrt(c(2,2)/rho);
v(3)=sqrt(c(3,3)/rho);
v(5)=sqrt(c(4,4)/rho);
v(6)=sqrt(c(5,5)/rho);
v(7)=sqrt(c(6,6)/rho);
		
qa=4*rho*rho;
qb=(-2*rho)*(c(1,1)+c(3,3)+2*c(4,4));
qc=(c(1,1)+c(4,4))*(c(3,3)+c(4,4))-(c(1,3)+c(4,4))^2;
vpsqrd=(-qb+sqrt(qb*qb-4*qa*qc))/(2*qa);
v(4)=sqrt(vpsqrd);




