function [vt,quality]=VK_velocity_tod(xibc,s,h,rho,vin,iso)
%
% [vt,quality]=velocity_tod(P,xibc,sm,hm,rho,vin,iso);
%
% Computes Tod velocities and assesses fit to observed velocities using the
% calculated initial aspect ratios and crack densities
%
%

for i=1:size(xibc,1)
    if iso == 1
        
        a(1)=xibc(i,1)/h(1);
        
        a(2)=a(1) ; a(3) = a(1);
    
    elseif iso == 2
        a = xibc(i,:)./h;
    end
    
     
    c1=s(2,3)*s(2,3) - (s(2,2)+a(2))*(s(3,3)+a(3));
	c2=s(1,3)*s(1,3) - (s(1,1)+a(1))*(s(3,3)+a(3));
	c3=s(1,2)*s(1,2) - (s(1,1)+a(1))*(s(2,2)+a(2));
		
	d1=s(2,3)*s(2,3)*(s(1,1) + a(1));
	d2=s(1,3)*s(1,3)*(s(2,2) + a(2));
	d3=s(1,2)*s(1,2)*(s(3,3) + a(3));
	d4=2*s(1,2)*s(1,3)*s(2,3);
	d5=(s(1,1)+a(1))*(s(2,2)+a(2))*(s(3,3)+a(3));
		
	d=d1+d2+d3-(d4+d5);
		
	ct(1,1)=c1/d;
	ct(2,2)=c2/d;
	ct(3,3)=c3/d;
	ct(1,3)=(s(1,3)*(s(2,2)+a(2))-s(1,2)*s(2,3))/d;
	ct(4,4)=1/(s(4,4)+a(2)+a(3));
	ct(5,5)=1/(s(5,5)+a(1)+a(3));
	ct(6,6)=1/(s(6,6)+a(1)+a(2));
    
    ct=VK_symmetry2d(ct,6);
    
    [vt(i,:)]=VK_ctov(ct,rho);
    
    
       
end

if iso == 1
    mvp=mean(vt(:,1:4),2);
    mvs=mean(vt(:,5:7),2);
    clear vt
    vt(:,1)=mvp;
    vt(:,2)=mvs;
end
    
quality=100*(abs(vin - vt)./vin);

