function [s,E,nu,mu,h]=VK_stiffness_properties(c)
%
% function [s,E,nu,mu,h]=stiffness_properties(c)
%
% Calculates compliance, Youngs, Poisson, shear and Gueguen from the
% stiffness tensor
%
% Written by J.P. Verdon, University of Bristol, 2012
%
%

% Compliance is inverse of stiffness
s=inv(c);

% Young's modulus
for i=1:3
    E(i)=1/s(i,i);
end

% Poisson's ratio
nu(1)=E(1)*(-s(1,2)-s(1,3))/2 ;
nu(2)=E(2)*(-s(2,1)-s(2,3))/2;
nu(3)=E(3)*(-s(3,1)-s(3,2))/2;
 
% Average shear modulus
mu(1)=(c(6,6)+c(5,5))/2;  
mu(2)=(c(6,6)+c(4,4))/2;
mu(3)=(c(5,5)+c(4,4))/2;

% Gueguen h factor
for i=1:3
    h(i)=3*E(i)*(2-nu(i))/(32*(1-nu(i)*nu(i)));
end

