function [alpha,znzt,vbc]=VK_crack_density_beta(P,vin,sm,h,rho,iso)
% function [alpha,znzt,vbc]=crack_density_beta(P,vin,cm,sm,E,nu,mu,h)
%
% Inverts velocity measurements for the Hall crack density tensors,
% including ZnZt and non-zero beta tensor
%
% Written by J.P. Verdon, University of Bristol, 2012
%
%

% Hardwire grid search over Zn/Zt
zmin=0;
zmax=2;
nzloop=400;
z=linspace(zmin,zmax,nzloop);

%maxtag=zeros(1,length(P));

for i=1:length(P)
    
    % Compute observed stiffnesses from vin
    co=VK_vtoc(vin(i,:),rho);
    
    % Loop over Zn/Zt to find best fit
    for j=1:nzloop
        
        % Initialise crack density tensor
        a11=0.0;
        a22=0.0;
        a33=0.0;
        
        f=z(j)-1;
        
        % Iterate to crack density
        for k=1:30
            av=(a11+a22+a33)/3;
            
            a1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)-(sm(2,2)+a22+f*av)*(sm(3,3)+a33+f*av);
			a2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)-(sm(1,1)+a11+f*av)*(sm(3,3)+a33+f*av);
			a3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)-(sm(1,1)+a11+f*av)*(sm(2,2)+a22+f*av);
			a13=(sm(1,3)+f*av/3)*(sm(2,2) + a22+f*av)-(sm(1,2)+f*av/3)*(sm(2,3)+f*av/3);
			a44=(sm(4,4) + a22 + a33 + 4*f*av/3);
			a55=(sm(5,5) + a11 + a33 + 4*f*av/3);
			a66=(sm(6,6) + a11 + a22 + 4*f*av/3);
			
			d1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)*(sm(1,1) + a11 + f*av);
			d2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,2) + a22 + f*av);
			d3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)*(sm(3,3) + a33 + f*av);
			d4=2*(sm(1,2)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,3)+f*av/3);
			d5=(sm(1,1)+a11+f*av)*(sm(2,2)+a22+f*av)*(sm(3,3)+a33+f*av);
		
			d=d1+d2+d3-(d4+d5);
            
            
            % Find derivatives of everything by everything
			dA1a11=2*sm(2,3)*(f/9) + 2*av*f*(f/27) - (sm(2,2)*(f/3)+a22*(f/3)+sm(3,3)*(f/3)+a33*(f/3)+2*av*f*(f/3));
            dA1a22=2*sm(2,3)*(f/9) + 2*av*f*(f/27) - (sm(3,3)+a33+sm(2,2)*(f/3)+f*(av+a22/3)+sm(3,3)*(f/3)+a33*(f/3)+2*av*f*(f/3));
			dA1a33=2*sm(2,3)*(f/9) + 2*av*f*(f/27) - (sm(2,2)+a22+sm(2,2)*(f/3)+f*(av+a33/3)+sm(3,3)*(f/3)+a22*(f/3)+2*av*f*(f/3));
				
			dA2a11=2*sm(1,3)*(f/9) + 2*av*f*(f/27) - (sm(3,3)+a33+sm(1,1)*(f/3)+f*(av+a11/3)+sm(3,3)*(f/3)+a33*(f/3)+2*av*f*(f/3));
			dA2a22=2*sm(1,3)*(f/9) + 2*av*f*(f/27) - (sm(1,1)*(f/3)+a11*(f/3)+sm(3,3)*(f/3)+a33*(f/3)+2*av*f*(f/3))	;
			dA2a33=2*sm(1,3)*(f/9) + 2*av*f*(f/27) - (sm(1,1)+a11+sm(1,1)*(f/3)+f*(av+a33/3)+sm(3,3)*(f/3)+a11*(f/3)+2*av*f*(f/3));
				
			dA3a11=2*sm(1,2)*(f/9) + 2*av*f*(f/27) - (sm(2,2)+a22+sm(1,1)*(f/3)+f*(av+a11/3)+sm(2,2)*(f/3)+a22*(f/3)+2*av*f*(f/3));
			dA3a22=2*sm(1,2)*(f/9) + 2*av*f*(f/27) - (sm(1,1)+a11+sm(2,2)*(f/3)+f*(av+a22/3)+sm(1,1)*(f/3)+a11*(f/3)+2*av*f*(f/3));
			dA3a33=2*sm(1,2)*(f/9) + 2*av*f*(f/27) - (sm(2,2)*(f/3)+a22*(f/3)+sm(1,1)*(f/3)+a11*(f/3)+2*av*f*(f/3));
				
			dA13a11=sm(1,3)*(f/3)+sm(2,2)*(f/9)+a22*(f/9)+2*av*f*(f/9) - (sm(1,2)*(f/9)+sm(2,3)*(f/9)+2*av*f*(f/27));
			dA13a22=sm(1,3)+sm(1,3)*(f/3)+sm(2,2)*(f/9)+(f/3)*(av+a22/3)+2*av*f*(f/9) - (sm(1,2)*(f/9)+sm(2,3)*(f/9)+2*av*f*(f/27));
			dA13a33=sm(1,3)*(f/3)+sm(2,2)*(f/9)+a22*(f/9)+2*av*f*(f/9) - (sm(1,2)*(f/9)+sm(2,3)*(f/9)+2*av*f*(f/27));	

            % Find differentials of D by a11, a22 and a33
            % D Diff by a11
			donea1=(sm(2,3)*sm(2,3) + 2*sm(2,3)*f*(av/3)+f*f*av*av/9)*(1+f/3)+(sm(1,1)+a11+f*av)*(2*sm(2,3)*(f/9) + 2*f*f*av/27);
			dtwoa1=(sm(1,3)*sm(1,3) + 2*sm(1,3)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(2,2)+a22+f*av)*(2*sm(1,3)*(f/9) + 2*f*f*av/27);
			dthra1=(sm(1,2)*sm(1,2) + 2*sm(1,2)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(3,3)+a33+f*av)*(2*sm(1,2)*(f/9) + 2*f*f*av/27);
			
			dfoua1=2*((sm(1,2)*sm(1,3)+sm(1,2)*f*(av/3)+sm(1,3)*f*(av/3)+f*f*av*av/9)*(f/9)+(sm(2,3)+f*av/3)*(sm(1,2)*(f/9)+ ... 
				sm(1,3)*(f/9)+2*f*f*av/27));
			
			
			
			ua1=(sm(1,1)*sm(2,2)+sm(1,1)*a22+sm(1,1)*f*av+sm(2,2)*a11+a11*a22+a11*f*av+sm(2,2)*f*av+a22*f*av+f*f*av*av);

			dfiva1=(ua1*f/3)+(sm(3,3)+a33+f*av)*(sm(1,1)*(f/3)+sm(2,2)+a22+f*(av+a11/3)+sm(2,2)*(f/3)+a22*(f/3) + 2*f*f*av/3);

            % D Diff by a22
			donea2=(sm(2,3)*sm(2,3) + 2*sm(2,3)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(1,1)+a11+f*av)*(2*sm(2,3)*(f/9) + 2*f*f*av/27);
			dtwoa2=(sm(1,3)*sm(1,3) + 2*sm(1,3)*f*(av/3)+f*f*av*av/9)*(1+f/3)+(sm(2,2)+a22+f*av)*(2*sm(1,3)*(f/9) + 2*f*f*av/27);
			dthra2=(sm(1,2)*sm(1,2) + 2*sm(1,2)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(3,3)+a33+f*av)*(2*sm(1,2)*(f/9) + 2*f*f*av/27);

			dfoua2=dfoua1;

			ua2=(sm(1,1)*sm(2,2)+sm(1,1)*a22+sm(1,1)*f*av+sm(2,2)*a11+a11*a22+a11*f*av+sm(2,2)*f*av+a22*f*av+f*f*av*av);

			dfiva2=(ua2*f/3)+(sm(3,3)+a33+f*av)*(sm(3,3)*(f/3)+sm(1,1)+a11+f*(av+a33/3)+sm(2,2)*(f/3)+a22*(f/3)+2*f*f*av/3);

            % D Diff by a33
			donea3=(sm(2,3)*sm(2,3)+2*sm(2,3)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(1,1)+a11+f*av)*(2*sm(2,3)*(f/9)+2*f*f*av/27);
			dtwoa3=(sm(1,3)*sm(1,3)+2*sm(1,3)*f*(av/3)+f*f*av*av/9)*(f/3)+(sm(2,2)+a22+f*av)*(2*sm(1,3)*(f/9)+2*f*f*av/27);
			dthra3=(sm(1,2)*sm(1,2)+2*sm(1,2)*f*(av/3)+f*f*av*av/9)*(1+f/3)+(sm(3,3)+a33+f*av)*(2*sm(1,2)*(f/9)+2*f*f*av/27);

			dfoua3=dfoua1;

			ua3=(sm(2,2)*sm(3,3)+sm(3,3)*a22+sm(3,3)*f*av+sm(2,2)*a33+a33*a22+a33*f*av+sm(2,2)*f*av+a22*f*av+f*f*av*av);

			dfiva3=(ua3*f/3)+(sm(1,1)+a11+f*av)*(sm(3,3)*(f/3)+sm(2,2)+a22+f*(av+a33/3)+sm(2,2)*(f/3)+a22*(f/3)+2*f*f*av/3);

			dDa1=donea1+dtwoa1+dthra1-dfoua1-dfiva1;
			dDa2=donea2+dtwoa2+dthra2-dfoua2-dfiva2;
			dDa3=donea3+dtwoa3+dthra3-dfoua3-dfiva3	;			

            % Find differentials of Cijs for a11, a22 and a33
			dC11a1=(d*dA1a11-a1*dDa1)/(d*d);
			dC11a2=(d*dA1a22-a1*dDa2)/(d*d);
			dC11a3=(d*dA1a33-a1*dDa3)/(d*d);

			dC22a1=(d*dA2a11-a2*dDa1)/(d*d);
			dC22a2=(d*dA2a22-a2*dDa2)/(d*d);
			dC22a3=(d*dA2a33-a2*dDa3)/(d*d);

			dC33a1=(d*dA3a11-a3*dDa1)/(d*d);
			dC33a2=(d*dA3a22-a3*dDa2)/(d*d);
			dC33a3=(d*dA3a33-a3*dDa3)/(d*d);
	
			dC13a1=(d*dA13a11-a13*dDa1)/(d*d);
			dC13a2=(d*dA13a22-a13*dDa2)/(d*d);
			dC13a3=(d*dA13a33-a13*dDa3)/(d*d);

			dC44a1=(-4*f/9)/(a44*a44);
			dC44a2=(-1-4*f/9)/(a44*a44);
			dC44a3=(-1-4*f/9)/(a44*a44);

			dC55a1=(-1-4*f/9)/(a55*a55);
			dC55a2=(-4*f/9)/(a55*a55);
			dC55a3=(-1-4*f/9)/(a55*a55);

			dC66a1=(-1-4*f/9)/(a66*a66);
			dC66a2=(-1-4*f/9)/(a66*a66);
			dC66a3=(-4*f/9)/(a66*a66);
            
            
            % Misfit between observed and predicted
            db(1,1)=co(1,1)-a1/d;
            db(2,1)=co(2,2)-a2/d;
            db(3,1)=co(3,3)-a3/d;
            db(4,1)=co(1,3)-a13/d;
            db(5,1)=co(4,4)-1/a44;
            db(6,1)=co(5,5)-1/a55;
            db(7,1)=co(6,6)-1/a66;
            
            A(1,:)=[dC11a1 dC11a2 dC11a3];
            A(2,:)=[dC22a1 dC22a2 dC22a3];
            A(3,:)=[dC33a1 dC33a2 dC33a3];
            A(4,:)=[dC13a1 dC13a2 dC13a3];
            A(5,:)=[dC44a1 dC44a2 dC44a3];
            A(6,:)=[dC55a1 dC55a2 dC55a3];
            A(7,:)=[dC66a1 dC66a2 dC66a3];

            dm=inv(A'*A)*A'*db;

            % update crack densities
            a11=a11+dm(1);
            a22=a22+dm(2);
            a33=a33+dm(3);
            
            alp(1,j)=a11*h(1);
            alp(2,j)=a22*h(2);
            alp(3,j)=a33*h(3);
            
        end
        
        % Compute back calculated velocities to compare misfit
        av=(a11+a22+a33)/3;
				
        a1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)-(sm(2,2)+a22+f*av)*(sm(3,3)+a33+f*av);
		a2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)-(sm(1,1)+a11+f*av)*(sm(3,3)+a33+f*av);
		a3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)-(sm(1,1)+a11+f*av)*(sm(2,2)+a22+f*av);
		a13=(sm(1,3)+f*av/3)*(sm(2,2) + a22+f*av)-(sm(1,2)+f*av/3)*(sm(2,3)+f*av/3);
		a44=(sm(4,4) + a22 + a33 + 4*f*av/3);
		a55=(sm(5,5) + a11 + a33 + 4*f*av/3);
		a66=(sm(6,6) + a11 + a22 + 4*f*av/3);
			
		d1=(sm(2,3)+f*av/3)*(sm(2,3)+f*av/3)*(sm(1,1) + a11 + f*av);
		d2=(sm(1,3)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,2) + a22 + f*av);
		d3=(sm(1,2)+f*av/3)*(sm(1,2)+f*av/3)*(sm(3,3) + a33 + f*av);
		d4=2*(sm(1,2)+f*av/3)*(sm(1,3)+f*av/3)*(sm(2,3)+f*av/3);
		d5=(sm(1,1)+a11+f*av)*(sm(2,2)+a22+f*av)*(sm(3,3)+a33+f*av);
		
		d=d1+d2+d3-(d4+d5);

		cbc(1,1)=a1/d;
		cbc(2,2)=a2/d;
		cbc(3,3)=a3/d;
		cbc(1,3)=a13/d;
		cbc(4,4)=1/a44;
		cbc(5,5)=1/a55;
		cbc(6,6)=1/a66;

        cbc=VK_symmetry2d(cbc,6); 
        
        [vbcmfc]=VK_ctov(cbc,rho);
        vcomp=vin(i,:);
        
        if iso == 1 % Make alpha and vbc isotropic
            mvp=mean(vbcmfc(1:4));
            mvs=mean(vbcmfc(5:7));
            clear vbcmfc
            vbcmf(j,1)=mvp;
            vbcmf(j,2)=mvs;
        else
            vbcmf(j,:)=vbcmfc;
        end
    
        mf(j)=sum(abs(vcomp-vbcmf(j,:))./vcomp);
  
    end
    [~,I]=min(mf);
    
    znzt(i)=z(I);
    
    alpha(i,:)=alp(:,I)';
    
    % Compute backcalculated velocities using best fit 
    vbc(i,:)=vbcmf(I,:);
    
end

        
        
        
        
        
        
        
        
        
        
        
        
        
        
            
            
            
            
            
            
            
            