function [alpha,vbc]=VK_crack_density(P,vin,sm,h,rho)
% function [alpha,vbc]=crack_density(P,vin,cm,sm,E,nu,mu,h)
%
% Inverts velocity measurements for the Hall crack density tensors
%
% Written by J.P. Verdon, University of Bristol, 2012
%
%

nloop=30;

% Loop over pressures
for i=1:length(P)
    
    % Initialise crack density tensors
    a11=0.0;
    a22=0.0;
    a33=0.0;
    
    % Compute observed stiffnesses from vin
    co=VK_vtoc(vin(i,:),rho);
    
    for j=1:nloop
        
        a1=sm(2,3)*sm(2,3)-(sm(2,2)+a22)*(sm(3,3)+a33);
		a2=sm(1,3)*sm(1,3)-(sm(1,1)+a11)*(sm(3,3)+a33);
		a3=sm(1,2)*sm(1,2)-(sm(1,1)+a11)*(sm(2,2)+a22);
		a13=sm(1,3)*(sm(2,2) + a22)-sm(1,2)*sm(2,3);
		a44=(sm(4,4) + a22 + a33);
		a55=(sm(5,5) + a11 + a33);
		a66=(sm(6,6) + a11 + a22);

		d1=sm(2,3)*sm(2,3)*(sm(1,1) + a11);
		d2=sm(1,3)*sm(1,3)*(sm(2,2) + a22);
		d3=sm(1,2)*sm(1,2)*(sm(3,3) + a33);
		d4=2*sm(1,2)*sm(1,3)*sm(2,3);
		d5=(sm(1,1)+a11)*(sm(2,2)+a22)*(sm(3,3)+a33);
		
		d=d1+d2+d3-(d4+d5);

% Find derivatives
		dDa1=sm(2,3)*sm(2,3) - (sm(2,2)+a22)*(sm(3,3)+a33);
		dDa2=sm(1,3)*sm(1,3) - (sm(1,1)+a11)*(sm(3,3)+a33);
		dDa3=sm(1,2)*sm(1,2) - (sm(1,1)+a11)*(sm(2,2)+a22);

		db(1,1)=co(1,1)-a1/d;
		db(2,1)=co(2,2)-a2/d;
		db(3,1)=co(3,3)-a3/d;
		db(4,1)=co(1,3)-a13/d;
		db(5,1)=co(4,4)-1/a44;
		db(6,1)=co(5,5)-1/a55;
		db(7,1)=co(6,6)-1/a66;

		dC11a1=-a1*dDa1/(d*d);
		dC11a2=(-(sm(3,3)+a33)*d - a1*dDa2)/(d*d);
		dC11a3=(-(sm(2,2)+a22)*d - a1*dDa3)/(d*d);

		dC22a1=(-(sm(3,3)+a33)*d - a2*dDa1)/(d*d);
		dC22a2=-a2*dDa2/(d*d);
		dC22a3=(-(sm(1,1)+a11)*d - a2*dDa3)/(d*d);
		
		dC33a1=(-(sm(2,2)+a22)*d - a3*dDa1)/(d*d);
		dC33a2=(-(sm(1,1)+a11)*d - a3*dDa2)/(d*d);
		dC33a3=-a3*dDa3/(d*d);
		
		dC13a1 = -a13*dDa1/(d*d);
		dC13a2 = (sm(1,3)*d - a13*dDa2)/(d*d);
		dC13a3 = -a13*dDa3/(d*d);
		
		dC44a1 = 0.0;
		dC44a2 = -1/(a44*a44);
		dC44a3 = -1/(a44*a44);

		dC55a1 = -1/(a55*a55);
		dC55a2 = 0.0;
		dC55a3 = -1/(a55*a55);

		dC66a1 = -1/(a66*a66);
		dC66a2 = -1/(a66*a66);
		dC66a3 = 0.0;
        
        A(1,:)=[dC11a1 dC11a2 dC11a3];
		A(2,:)=[dC22a1 dC22a2 dC22a3];
		A(3,:)=[dC33a1 dC33a2 dC33a3];
		A(4,:)=[dC13a1 dC13a2 dC13a3];
		A(5,:)=[dC44a1 dC44a2 dC44a3];
		A(6,:)=[dC55a1 dC55a2 dC55a3];
		A(7,:)=[dC66a1 dC66a2 dC66a3];

        dm=inv(A'*A)*A'*db;

        % update crack densities
		a11=a11+dm(1);
		a22=a22+dm(2);
		a33=a33+dm(3);
    
    end
    % Normalise crack densities
    alpha(i,1) = a11*h(1);
    alpha(i,2) = a11*h(2);
    alpha(i,3) = a33*h(3);
    
    
    % Compute back-calculated velocities
    cbc(1,1)=a1/d;
	cbc(2,2)=a2/d;
	cbc(3,3)=a3/d;
	cbc(1,3)=(sm(1,3)*(sm(2,2)+a22)-sm(1,2)*sm(2,3))/d;
	cbc(4,4)=1/(sm(4,4)+a22+a33);
	cbc(5,5)=1/(sm(5,5)+a11+a33);
	cbc(6,6)=1/(sm(6,6)+a11+a22);
    
    cbc=VK_symmetry2d(cbc,6);
    
    vbc(i,:)=VK_ctov(cbc,rho);
end























