function tag = RS_SeedTag(dims,ns,xg,yg,zg,seeds)
%
% function tag = RS_SeedTag(dims,ng,ns,grid,seeds)
%
% Tag each seed point to the nearest geomechanical grid node
%
% INPUTS:   dims = dimensions (2 or 3)
%           ns = number of seed points
%           yg,xg = x and y grid coords
%           seeds = x and y coors of each seed point
%           
% OUTPUTS:  tag = tag linking each seed to a grid node
%
% Written by J.P. Verdon, 2014
% University of Bristol
%



tag=NaN(ns,1);

if dims == 3
    for i=1:ns
        d = sqrt((seeds(i,1)-xg).^2 + (seeds(i,2)-yg).^2 + (seeds(i,3)-zg).^2);
        [~,ind] = min(d);
        tag(i)=ind;
    end
elseif dims == 2
    for i=1:ns
        d = sqrt((seeds(i,1)-xg).^2 + (seeds(i,2)-yg).^2);
        [~,ind] = min(d);
        tag(i)=ind;
    end
else
     fprintf('%s \n',['seed_tag: Incorrect number of dimensions']);
end




