function [coh,muf,ts] = RS_SeedMC(ns,method,vector)
%
% fuction [coh,muf,ts] = RS_SeedMC(ns,'uniform',vector)
%
% e.g.: [coh,muf,ts] = seed_mc(30000,'uniform',[coh_min coh_max, muf_min muf_max, ts_min ts_max])
%                   OR
%       [coh,muf,ts] = seed_mc(30000,'normal',[mean_coh std_coh mean_muf std_muf mean_ts std_ts])
%
% Assigns random Mohr-Coulomb criteria to every seed point, using either a
% uniform or normal distribution
%
% INPUTS:   ns = number of seeds
%           method = 'normal' or 'uniform'
%           vector = minimum and maximum cohesion and friction coefficient
%                    values (for 'uniform') or means and stds
%
% OUTPUTS:  seeds = 2 x ns vector listing seed point cohesions, friction
%                   coefficients and tensile strength
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


ts = NaN;
if strcmpi(method,'normal')
    
    
    coh = vector(1) + vector(2)*randn(ns,1);
    muf = vector(3) + vector(4)*randn(ns,1);
    if nargout > 2
        ts = vector(5) + vector(6)*randn(ns,1);
    end
        
elseif strcmpi(method,'uniform')
    
    coh = vector(1) + rand(ns,1) * (vector(2) - vector(1));
    muf = vector(3) + rand(ns,1) * (vector(4) - vector(3));
    if nargout > 2
        ts = vector(5) + rand(ns,1) * (vector(6) - vector(5));
    end

else
    fprintf('%s \n',['seed_points: method ',method,' not recognised']);    
end

% Additional checks for non-physical M-C values
coh(coh<0) = 0;
muf(muf<0) = 0;
muf(muf>1) = 1;
ts(ts<0) = 0;

