function [shear] = RS_ProcessEvents(seeds,ifig)
%
% function [shear,tensile] = RS_ProcessEvents(seeds)
%
% Post-processing for RandomSeed - find triggered seeds and create an event
% catalogue. 
%
% events structure has the following fields:
%  t = event occurrence time
%  x,y,z = event coords
%  strike = event fault plane strike
%  dip = event fault plane dip
%  rake = event slip direction
%  mag = event magnitude
%  sn = normal stress prior to event
%  tau = shear stress prior to event
%  ds = event stress drop
%
%
% Written by J.P. Verdon, 2014
% University of Bristol
%



if isempty(seeds.sheartag(seeds.sheartag(:,2:seeds.nt)==1))
    shear=struct('n',NaN,'t',NaN,'x',NaN,'y',NaN,'z',NaN,'lith',NaN,'strike',NaN,'dip',NaN,...
        'rake',NaN,'mag',NaN,'sn',NaN,'tau',NaN,'ds',NaN,'ne',NaN);
end
        
c=0;
d=0;
    
for i=2:seeds.nt
    for j=1:seeds.ns
        
        if seeds.sheartag(j,i) == 1
            
            c = c+1;
            shear.n(c) = j;
            shear.t(c) = i;
            shear.x(c) = seeds.x(j);
            shear.y(c) = seeds.y(j);
            shear.z(c) = seeds.z(j);
            shear.l(c) = seeds.l(j)*seeds.lmod(j);
            shear.strike(c) = seeds.str(j);
            shear.dip(c) = seeds.dip(j);
            shear.rake(c) = seeds.rake(j,i);
            shear.mag(c) = seeds.mag(j,i);
            shear.sn(c) = seeds.sn(j,i);
            shear.tau(c) = seeds.tau(j,i);
            shear.ds(c) = seeds.ds(j,i);
            
            
            if mean(seeds.sheartag(j,2:i-1)) > 0
                shear.ra(c) = 1;
            else
                shear.ra(c) = 0;
            end
            
        end        
        
    end
end

shear.ne = c;

            