function seeds = RS_InitialiseSeeds(ns,nt)
%
% function seeds = RS_InitialiseSeeds(ns,nt)
%
% Initialise random seed structure ready for RandomSeed analysis. seeds
% structure is as follows:
%
% 1-D (scalar values)
% ns = number of seed points
% nt = number of time steps for evaluation
% xs = seed x locations
% ys = seed y locations
% zs = seed z locations
% tag = tag to link each seed point with a geomechanical node
% strike = seed point strike (0 - 360 degrees)
% dip = seed point dip (0 - 90 degrees)
% cohesion = seed point cohesion
% muf = seed point angle of friction
%
% 3-D (vector values)
% smod = stress modulation values - values by which each principal stress 
%        is modulated from the geomech model
% srot = stress rotation angles - 3 Euler angles by which the stress tensor
%        is rotated from the geomechanical model
%
% Dimension(ns,nt) values (values for each ssed point updated at each time step)
% sn = normal stress acting on seed point
% tau = shear stress acting on seed point
% failuretag = tag to indicate if an event has occurred
% rake = rake defining slip direction on seed point
% ds = stress drop for an event
% mag = magnitude of an event
% 
% R = rotation matrix from global to fault slip coordiantes (3x3 matrix).
%     This is necessary to deduct stress drops from subsequent stresses
%     after a failure event
% 
%
% Written by J.P. Verdon, 2014
% University of Bristol
%


seeds.ns = ns;
seeds.nt = nt;

seeds.x = NaN(ns,1);
seeds.y = NaN(ns,1);
seeds.z = NaN(ns,1);
seeds.tag = NaN(ns,1);
seeds.str = NaN(ns,1);
seeds.dip = NaN(ns,1);
seeds.l = NaN(ns,1);
seeds.cohesion = NaN(ns,1);
seeds.muf = NaN(ns,1);
seeds.smod = NaN(ns,3);
seeds.srot = NaN(ns,3);
seeds.lmod = NaN(ns,1);


%seeds.ts = NaN(ns,1);

seeds.sn = NaN(ns,nt);
seeds.tau = NaN(ns,nt);
seeds.sheartag = zeros(ns,nt);
%seeds.tensiletag = zeros(ns,nt);
seeds.rake = NaN(ns,nt);
seeds.ds = NaN(ns,nt);
seeds.mag = NaN(ns,nt);

seeds.R = cell(ns,nt);

