function S = RS_EulerRotate(So,ang)
%
% function S = RS_EulerRotate(So,ang)
%
% Rotate stress tensor by Euler angles.
%
% Euler-rotate uses the 'pitch-roll-yaw' convention described in 
% Wolfram-Mathworld (http://mathworld.wolfram.com/EulerAngles.html). 
%
% INPUTS:	So = initial stress tensor (3x3)
%			ang = vector of length 3 listing the 3 Euler angles: 
%                   ang(1) = yaw, 
%                   ang(2) = pitch,
%                   ang(3) = roll
%
% OUTPUTS:	S = rotated stress tensor (3x3)
%
% Written by J.P. Verdon, 2014
% University of Bristol
%



D=[cosd(ang(1)) sind(ang(1)) 0 ; ...
    -sind(ang(1)) cosd(ang(1)) 0 ; 0 0 1]; 

C=[cosd(ang(2)) 0 -sind(ang(2)) ; 0 1 0 ; ...
	sind(ang(2)) 0 cosd(ang(2))]; 

B=[1 0 0 ; 0 cosd(ang(3)) sind(ang(3)) ; ...
	0 -sind(ang(3)) cosd(ang(3))];

A = B*C*D;

% Perform rotation
S = A*So*A';


