!***************************************************************************************************
subroutine user_init(nd,ranges,scales)
!---------------------------------------------------------------------------------------------------
!
! Subroutine USER_INIT initialises the parameter ranges and scaling factors for a NA run. The
! ranges are taken from the variables already read during the read of the control file
!
! User defined subroutine for the NA algorithm
!
! Calls to other routines:
!    Uses insaff_globals module to access global variables
!
!
!***************************************************************************************************

use insaff_globals

implicit none

integer i,j,nd
real*4 ranges(2,*),scales(*)

scales(1)=1.0

nd=np

do i=1,nd
	do j=1,2
		ranges(j,i) = rng(j,i)
	enddo
	scales(i)=-1
enddo

return
end subroutine user_init
!***************************************************************************************************



!***************************************************************************************************
subroutine forward(nd,model,lppd,nmod,inumber)
!---------------------------------------------------------------------------------------------------
!
! Subroutine FORWARD computes the model-observation misfit for a given point in the parameter space
!
! User defined subroutine for the NA algorithm
!
! Calls to other routines:
!    Uses the insaff_globals module to access global variables
!    Uses the insaff_lib module for elastic stiffness subroutines
!
! Written by J.P. Verdon, University of Bristol, 2008-2011
!
!***************************************************************************************************

use insaff_globals
use insaff_lib

implicit none

integer 				:: i,nd,m,nmod,inumber
real 					:: lppd,model(nd),mf(3),mftot,mfpsi,mfmag
real					:: eps,gam,del,zn,zt,xi,alp,xi2,alp2,dip,vp,vss,vsf	
real,dimension(6,6)		:: c
real,dimension(nmeas)	:: fast,mag

! Map NA model variables into rock physics parameters depending on model type, and compute C
select case (rp)
	case (1)
		gam=model(1)
		del=model(2)
		eps=model(3)

		c=cvti(vpi,vsi,rho,eps,gam,del)
		
	case (2)
		xi=model(1)
		alp=model(2)
		gam=gami
		del=deli
		eps=epsi
		! Params for standard test case
		!xi = 0.1
		!alp = 30
		!gam = 0.1
		!eps = 0.2
		!del = 0.15
		c=cvtifrac(vpi,vsi,rho,xi,alp,eps,gam,del)
		
	case (3)
		xi=model(1)
		alp=model(2)
		dip=model(3)
		gam=gami
		del=deli
		eps=epsi
		
		c=cdipfr(vpi,vsi,rho,xi,alp,dip,eps,gam,del)
		
		
	case (4)
		xi=model(1)
		alp=model(2)
		xi2=model(3)
		alp2=model(4)
		gam=gami
		del=deli
		eps=epsi
		
		c=cdfrac(vpi,vsi,rho,xi,alp,xi2,alp2,eps,gam,del)
		
	case (5)
		xi=model(1)
		alp=model(2)
		eps=model(3)
		gam=model(4)
		del=model(5)
		
		c=cvtifrac(vpi,vsi,rho,xi,alp,eps,gam,del)
		
	case (6)
		zt=model(1)
		zn=model(2)*model(1)
		alp=model(3)
		gam=gami
		del=deli
		eps=epsi
		
		c=cvtifrac_znzt(vpi,vsi,rho,zn,zt,alp,eps,gam,del)
		
	case (7)
		zt=model(1)
		zn=model(2)*model(1)
		alp=model(3)
		dip=model(4)
		gam=gami
		del=deli
		eps=epsi
		stop 'Dipping fractures with ZnZt has not been coded'
	!	c=cdipfr_znzt(vpi,vsi,rho,zn,zt,alp,dip,eps,gam,del)
	
	case (8)
		zt=model(1)
		zn=model(2)*model(1)
		alp=model(3)
		eps=model(4)
		gam=model(5)
		del=model(6)
		
		c=cvtifrac_znzt(vpi,vsi,rho,zn,zt,alp,eps,gam,del)
		
end select

! Initialise psi and mag misfits
mfmag=0.0
mfpsi=0.0

! Loop over splitting measurements
do m=1,nmeas
	! Compute modelled splitting operators for each arrival angle
	!if (irevaz.eq.1)then 
	!	call anisvelocity(c,rho,90-az(m),90-inc(m),vp,vsf,vss,fast(m))
	!else
		call anisvelocity(c,rho,az(m),inc(m),vp,vsf,vss,fast(m))
	!endif
	
	! Compare modelled and observed operators and compute RMS errors
	if (fast(m).lt.0)fast(m)=fast(m)+180
	mf(1)=(ofast(m)-fast(m))*(ofast(m)-fast(m))  ! Deal with cyclicity
	mf(2)=(ofast(m)-fast(m)-180)*(ofast(m)-fast(m)-180)
	mf(3)=(ofast(m)-fast(m)+180)*(ofast(m)-fast(m)+180)
	mfpsi=mfpsi+minval(mf)
					
	mag(m)=100*(vsf-vss)/((vsf+vss)/2)
	mf(1)=(omag(m)-mag(m))*(omag(m)-mag(m))
	mfmag=mfmag+mf(1)
enddo

if (inumber.eq.1)then
	! For the first run, return the psi misfit, and save the minimum
	lppd = mfpsi
	if (mfpsi.lt.minpsi) then
		minpsi=mfpsi
		if (itype.eq.2)mftot=mfpsi
		do i=1,nd
			finalmodel(i)=model(i)
		enddo
	endif
elseif (inumber.eq.2)then
	! For the second run, return the mag misfit, and save the minimum
	lppd = mfmag
	if (mfmag.lt.minmag) then
		minmag=mfmag
		if (itype.eq.2)mftot=mfmag
		do i=1,nd
			finalmodel(i)=model(i)
		enddo
	endif
elseif (inumber.eq.3)then
	! For the final run, return the combined misfits, normalised by their minima
	if (itype.eq.1)mftot=(mfpsi/minpsi)+(mfmag/minmag)
	if (itype.eq.4)mftot=(mfpsi/minpsi)+wfact*(mfmag/minmag)
	lppd = mftot
	if (mftot.lt.minmf) then
		minmf=mftot
		do i=1,nd
			finalmodel(i)=model(i)
		enddo
	endif
endif

return
end subroutine forward
!***************************************************************************************************
