#include "fintrf.h"
program insaff
!***************************************************************************************************
!
!   INSAFF
!      (Inverting Seismic Anisotropy for Fractures and Fabrics)
!
!     (C) James Verdon, January 2008 - October 2015
!       Deptartment of Earth Sciences, University of Bristol
!       james.verdon@bristol.ac.uk
!
!     For more details please see:
!       J.P. Verdon et al., 2009, GJI.
!       J.P. Verdon et al., 2011, Geophys. Prosp.
!		A. Wuestefeld et al., 2011, Geophysics
!		J.P. Verdon and A. Wuestefeld, 2013, Geophys. Prosp.
!
!-------------------------------------------------------------------------------
!  This software is distributed in the hope that it will be useful, but WITHOUT
!  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
!  FITNESS FOR A PARTICULAR PURPOSE.
!
!  This software is distributed for ACADEMIC PURPOSES and is not to be 
!  distributed to any other parties.  This code is NOT TO BE INTEGRATED 
!  within or developed into COMMERCIAL CODE unless WRITTEN PERMISSION 
!  is given by the authors.
!-------------------------------------------------------------------------------
!
!     Last edited: October 2015
!
!***************************************************************************************************

use io_lib 
use insaff_globals
use na_globals
use insaff_lib

implicit none
integer			:: i

! Write helpful things to the screen if asked
call gethelp


! Get command line inputs:
write(6,*)' --> Reading Command Line Inputs'
if(.not.get_cmnd_string('controls',cfile,lc)) then
	cfile='insaff.in' 
	lc=9
endif

! Get the data file
if(.not.get_cmnd_string('data',dfile,ld)) stop 'No data file has been specified'

! Get the NA direct access file
if(.not.get_cmnd_string('nadafile',nafile,lnaf)) lnaf=-1

! Get the output file
if(.not.get_cmnd_string('output',ofile,lo)) lo=-1

! Find whether to plot a matlab sphere
if(.not.get_cmnd_string('matlabsphere',imsph,limsph)) then
	imsph = 'no'
	limsph = 2
endif

! Decimate observations
!if(.not.get_cmnd_int('decimate',ndec)) ndec=0

! Get control options from input file
write(6,*)' --> Reading Inversion Controls from "',cfile(1:lc),'"'
call input


! Read SWS data from file
write(6,*)' --> Reading the splitting data file: "',dfile(1:ld),'"'
call read_data(dfile(1:ld),ld,az,inc,ofast,omag,nmeas,ndec)
write(6,*)'     --> ',nmeas,'measurements have been read'
if (isettype.eq.1)then
	do i = 1,nmeas
		ofast(i) = ofast(i) - az(i)
		az(i) = modulo(az(i),360.0)
	enddo
endif


! Begin inversion
write(6,*)' --> Inverting for rock physics model'
minpsi=1e24
minmag=1e24
minmf=1e24

if (itype.eq.2)then
	write(6,*)' --> Inverting for psi'
	call nearestneighbour(cfile,lc,nafile,lnaf,1)
elseif (itype.eq.3)then
	write(6,*)' --> Inverting for psi'
	call nearestneighbour(cfile,lc,nafile,lnaf,2)
elseif (itype.eq.1.or.itype.eq.4)then
	write(6,*)' --> Inverting for psi'
	call nearestneighbour(cfile,lc,nafile,-1,1)
	write(6,*)' --> Inverting for mag'
	call nearestneighbour(cfile,lc,nafile,-1,2)
	write(6,*)' --> Inverting for combined'
	call nearestneighbour(cfile,lc,nafile,lnaf,3)
endif



! Write inversion results to output file (also generate GMT hemisphere plot)
call output

write(6,*)
write(6,*)' --> INSAFF finished'
write(6,*)




end program insaff
!***************************************************************************************************
