!***************************************************************************************************
subroutine gethelp
!---------------------------------------------------------------------------------------------------
! Subroutine gethelp provides useful help to the user when prompted
!
!---------------------------------------------------------------------------------------------------
use io_lib 

implicit none
character*256					:: helptype
integer							:: lht

! Command line help to describe inputs
if (get_cmnd_log('help'))then
    write(6,*)
    write(6,*)'   *****************************************************************'
    write(6,*)'   *                          InSAFF                               *'
    write(6,*)'   *     Inverting Seismic Anisotropy for fabrics and fractures    *'
    write(6,*)'   *                using NA inversion algorithm                   *'
    write(6,*)'   *                (c) J.P. Verdon 2008 - 2015                    *'
    write(6,*)'   *****************************************************************'
    write(6,*)
	write(6,*)'Inverts SWS data for rock physics parameters (fracture density, strike etc), using ',&
	'the Neighbourhood Algorithm to search the parameter space'
	write(6,*)''
	write(6,*)' INPUTS:'
	write(6,*)'   controls=  (optional,char) keyword-driven file controlling the INSAFF inversion ',&
	'method (e.g., rock physics type, grid search limits)'
     write(6,*)'             (default=insaff.in)'
	write(6,*)'   data=      (required,char) file containing the SWS data' 
	write(6,*)'   output=    (optional,char) location to write inversion results'
	write(6,*)'              (if not set, no results are written to file)'
	write(6,*)'   nadafile=  (optional,char) output NA direct access file created by NA algorithm, ',&
	'listing the model ensemble'
	write(6,*)'              (If not set, no direct access file is created)'
!	write(6,*)'   decimate=  (optional,integer) provides the option to sample the observed data at ',&
!	'intervals of n (useful for a quick overview of large datasets'
	write(6,*)'   setup=     (optional,string) dictates whether the data is from a surface or ',&
	'downhole array (default is downhole)'
	write(6,*)'   matlabsphere=     (optional,string) dictates whether a matlab polefigz sphere is produced ',&
	'using MSAT functions'

	if(get_cmnd_string('help',helptype,lht)) then
		if (helptype(1:lht).eq.'controls')then
			write(6,*)' '
			write(6,*)' ' 
			write(6,*)' CONTROL FILE INPUTS '
			write(6,*)' '
			write(6,*)'rockphysicsmodel=string      | Use string to define the rock physics model to be used, from a choice of'
			write(6,*)'       "vti" = vti only (1)'
			write(6,*)'       "verticalscalar" = single vertical scalar fracture (2)'
			write(6,*)'       "dippingscalar" = single dipping scalar fracture (3)'
			write(6,*)'       "doubleverticalscalar" = two vertical scalar fractures (4)'
			write(6,*)'       "vtiandverticalscalar" = vti and a single vertical scalar fracture (5)'
			write(6,*)'       "verticalznzt" = single vertical zn/zt fracture (6)'
			write(6,*)'       "dippingznzt" = single dipping zn/zt fracture (7)'
			write(6,*)'       "vtiandverticalznzt" = vti and a single zn/zt fracture (8)'
		
			write(6,*)
			write(6,*)'inversiontype=string     | Use string to define the inversion type to be used, from a choice of'
			write(6,*)'       "equal" = weight psi and dVs equally (1)'
			write(6,*)'       "psi" = use fast polarisations only (2)'
			write(6,*)'       "dvs" = use dVs only (3)'
			write(6,*)'       "weighted" = weighted misfit function, where MF = MF(psi) + W*MF(mag)'
			write(6,*)'            if weighted is used, then the weight factor W must be defined using:'
			write(6,*)'            weightfactor='
			write(6,*) 
			write(6,*)'background=vp,vs,rho  | Define background Vp, Vs and density (floats)'
			write(6,*)
			write(6,*)'ranges=      | Define parameter ranges in a list following the ranges keyword. Possible parameters include:'
			write(6,*)'       "epsilon" = Thomsens parameter'   
			write(6,*)'       "gamma" = Thomsens parameter' 
			write(6,*)'       "delta" = Thomsens parameter' 
			write(6,*)'       "fracden" = frac density for a single scalar fracture set model'
			write(6,*)'       "fracden1" = 1st frac density for a double scalar fracture set model'
			write(6,*)'       "fracden2" = 2nd frac density for a double scalar fracture set model'
			write(6,*)'       "strike" = strike of fractures for any single fracture set model'
			write(6,*)'       "strike1" = 1st frac strike for any double fracture set model'
			write(6,*)'       "strike2" = 2nd frac strike for any double fracture set model'
			write(6,*)'       "dip" = dip of fractures for any single fracture set ',&
			 'model, Dip is angle of frac-normal to horizontal, right-handed'
			write(6,*)'       "zt" = tangential compliance of zn/zt fractures (normalised by the Gueguen "h" parameter)'
			write(6,*)'       "znzt" = zn/zt ratio of zn/zt fracture sets'
			write(6,*)
			
			write(6,*)'na_options=     | Define NA search parameters in a list including the following:'
			write(6,*)'       "maxiterations" '
			write(6,*)'       "initialsample" '
			write(6,*)'       "subsample" '
			write(6,*)'       "nresample" '
			write(6,*)'               See Sambridge et al. (1999) for parameter explanations'

			write(6,*)
			write(6,*)'fixedepsilon=     | For inversions where VTI is not free, a fixed VTI can be defined'
			write(6,*)'fixedgamma=     | For inversions where VTI is not free, a fixed VTI can be defined'
			write(6,*)'fixeddelta=     | For inversions where VTI is not free, a fixed VTI can be defined'
		
		elseif (helptype(1:lht).eq.'data')then
			write(6,*)' '
			write(6,*)' ' 
			write(6,*)' INPUT DATA FORMAT '
			write(6,*)' '
			write(6,*)'Input data must be placed in comma or space delimited columns, listing:'
			write(6,*)'      Azimuth, Inclination, Polarisation, dVs'
			write(6,*)
			write(6,*)'Azimuth is the angle from source to receiver, in geographical coords (i.e. degrees from north)'
			write(6,*)'Inclination is the angle from source to receiver, in degrees, where 0 is horizontal and 90 is upwards'
			write(6,*)'Polarisation is the fast S direction. '
			write(6,*)'       If "setup" is surface, this is the fast angle clockwise from north'
			write(6,*)'       If "setup" is downhole, this is the angle clockwise from the qSv direction'
			write(6,*)'dVs is the average S-wave velocity difference, dVs = Vs1-Vs2/Vavg.'
			write(6,*)'       dVs can be computed from measured dt by pathlength normalisation: dVs = dt*Vavg/D'
			write(6,*)
			 
		endif

	endif

	
	stop
endif


end subroutine gethelp