!***************************************************************************************************
!
!   io_lib.f90
!      contains subroutines to read keyword driven command lines and data files
!
!   Written by J.P. Verdon, University of Bristol, 2011
!      based on libraries from K. Chambers, UoB, 2006-2010.
!
!-------------------------------------------------------------------------------
!  This software is distributed in the hope that it will be useful, but WITHOUT
!  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
!  FITNESS FOR A PARTICULAR PURPOSE.
!
!  This software is distributed for ACADEMIC PURPOSES and is not to be 
!  distributed to any other parties.  This code is NOT TO BE INTEGRATED 
!  within or developed into COMMERCIAL CODE unless WRITTEN PERMISSION 
!  is given by the authors.
!-------------------------------------------------------------------------------
!
!     Last edited: March 2011
!
!***************************************************************************************************

module io_lib

contains
      
!***************************************************************************************************
  logical function get_cmnd_log(line_id)
!***************************************************************************************************
implicit none
character*(*)		       		:: line_id
character*256 		       		:: char,command 
integer					   		:: i,ll,l,istat

get_cmnd_log=.false.
call init_char_null(char)
call init_char_null(command)
l=icharlen(line_id)
call get_command(command,i,istat)
i=1
do 
	call get_command_argument(i,char,ll,istat)
	if(ll.eq.0) exit
	if(char(1:l).eq.line_id(1:l).and.char(l+1:l+1).eq.'=') then
		get_cmnd_log=.true.
		exit
	endif
	i=i+1	   
enddo

end function get_cmnd_log
!***************************************************************************************************


!***************************************************************************************************
  logical function get_cmnd_string(line_id,string,ly)
!***************************************************************************************************
implicit none
character*(*)		       :: line_id,string
character*256 		       :: char,command   
integer					   :: ly,istat,i,l,ll

call init_char_null(string)
call init_char_null(char)
call init_char_null(command)

get_cmnd_string=.false.
l=icharlen(line_id)
call get_command(command,i,istat)
i=1
do 
	call get_command_argument(i,char,ll,istat)                
	if(ll.eq.0) exit
	if(char(1:l).eq.line_id(1:l).and.char(l+1:l+1).eq.'=') then
		ly=ll-l-1
  	    string(1:ly)=char(l+2:ll)
  	    get_cmnd_string=.true.
  	    exit
  	endif	   
    i=i+1 
enddo
  
end function get_cmnd_string
!***************************************************************************************************


!***************************************************************************************************  	 
  logical function get_cmnd_int(line_id,ii)
!***************************************************************************************************
implicit none
character*(*)		       	:: line_id
character*256 		       	:: char,command  
integer						:: ii,ll,istat,i,l,len

call init_char_null(command)
call init_char_null(char)

get_cmnd_int=.false.
l=icharlen(line_id)
call get_command(command,len,istat)
i=1
do 
	call get_command_argument(i,char,ll,istat)
    	if(ll.eq.0) exit
  	    if(char(1:l).eq.line_id(1:l).and.char(l+1:l+1).eq.'=') then
  	    	read(char(l+2:ll),*)ii
  	       	get_cmnd_int=.true.
  	       	exit
  	  	endif
    i=i+1	   
enddo
  
end function get_cmnd_int  	 
!***************************************************************************************************


!***************************************************************************************************
   logical function get_cmnd_float(line_id,val)
!***************************************************************************************************
implicit none
character*(*)		       :: line_id
character*256 		       :: char,command
real					   :: val
integer					   :: i,l,ll,istat

call init_char_null(char)
call init_char_null(command)
get_cmnd_float=.false.
l=icharlen(line_id)
call get_command(command,i,istat)
i=1
do 
	call get_command_argument(i,char,ll,istat)                
	if(ll.eq.0) exit
	if(char(1:l).eq.line_id(1:l).and.char(l+1:l+1).eq.'=') then
		read(char(l+2:ll),*)val
  	    get_cmnd_float=.true.
  	    exit
  	endif	   
    i=i+1 
enddo
  
end function get_cmnd_float
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_int(line_id,unit,val)
!***************************************************************************************************
implicit none
character*(*)				:: line_id
character*256				:: line
integer						:: val,i,ll,l,unit,istat

l=icharlen(line_id)

get_input_int=.false.
i=1
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		read(line(l+2:ll),*)val
		get_input_int=.true.
		exit
	endif
	i=i+1
enddo

end function get_input_int
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_float(line_id,unit,val)
!***************************************************************************************************
implicit none
character*(*)				:: line_id
character*256				:: line
integer						:: i,ll,l,unit,istat
real						:: val

l=icharlen(line_id)

get_input_float=.false.
i=1
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		read(line(l+2:ll),*)val
		get_input_float=.true.
		exit
	endif
	i=i+1
enddo

end function get_input_float
!***************************************************************************************************


!***************************************************************************************************
  logical function get_input_mult(line_id,unit,val,lv)
!***************************************************************************************************
implicit none
character*(*)				:: line_id
character*256				:: line,dummy
integer						:: i,ll,l,lv,unit,istat
real						:: val(lv)

l=icharlen(line_id)

get_input_mult=.false.
i=1
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		read(line(l+2:ll),*)val(1)
		backspace(unit)
		read(unit,*)dummy,val(2:lv)
		get_input_mult=.true.
		exit
	endif
	i=i+1
enddo

end function get_input_mult
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_string(line_id,unit,val,lline)
!***************************************************************************************************
implicit none
character*(*)				:: line_id
character*256				:: line,val
integer						:: i,ll,l,unit,istat,lline

l=icharlen(line_id)

get_input_string=.false.
i=1
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		read(line(l+2:ll),*)val
		get_input_string=.true.
		lline=ll-l-1
		exit
	endif
	i=i+1
enddo

end function get_input_string
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_list_int(line_id,subline_id,unit,val)
!***************************************************************************************************
implicit none
character*(*)				:: line_id,subline_id
character					:: test
character*256				:: line,dummy
integer						:: i,j,iend,ll,l,ls,unit,istat
integer						:: val

l=icharlen(line_id)
ls=icharlen(subline_id)

get_input_list_int=.false.
i=1
iend=0
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		do
			read(unit,FMT='(A)',iostat=istat)test ! Look for blank lines to end list 
			if (len_trim(test).eq.0)then
				iend=1
				exit
			endif
			backspace(unit)
			read(unit,*,iostat=istat)line
			ll=icharlen(line)
			if (istat.lt.0) exit
			if(line(1:ls).eq.subline_id(1:ls).and.line(ls+1:ls+1).eq.'=')then
				read(line(ls+2:ll),*)val
				get_input_list_int=.true.
				iend=1
				exit
			endif
			j=j+1
		enddo
	endif
	if (iend.eq.1)exit
	i=i+1
enddo

end function get_input_list_int
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_list_float(line_id,subline_id,unit,val)
!***************************************************************************************************
implicit none
character*(*)				:: line_id,subline_id
character					:: test
character*256				:: line,dummy
integer						:: i,j,iend,ll,l,ls,unit,istat
real						:: val

l=icharlen(line_id)
ls=icharlen(subline_id)

get_input_list_float=.false.
i=1
iend=0
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		do
			read(unit,FMT='(A)',iostat=istat)test ! Look for blank lines to end list 
			if (len_trim(test).eq.0)then
				iend=1
				exit
			endif
			backspace(unit)
			read(unit,*,iostat=istat)line
			ll=icharlen(line)
			if (istat.lt.0) exit
			if(line(1:ls).eq.subline_id(1:ls).and.line(ls+1:ls+1).eq.'=')then
				read(line(ls+2:ll),*)val
				get_input_list_float=.true.
				iend=1
				exit
			endif
			j=j+1
		enddo
	endif
	if (iend.eq.1)exit
	i=i+1
enddo

end function get_input_list_float
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_list_string(line_id,subline_id,unit,val,lline)
!***************************************************************************************************
implicit none
character*(*)				:: line_id,subline_id,val
character					:: test
character*256				:: line,dummy
integer						:: i,j,iend,ll,l,ls,unit,istat,lline

l=icharlen(line_id)
ls=icharlen(subline_id)

get_input_list_string=.false.
i=1
iend=0
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		do
			read(unit,FMT='(A)',iostat=istat)test ! Look for blank lines to end list 
			if (len_trim(test).eq.0)then
				iend=1
				exit
			endif
			backspace(unit)
			read(unit,*,iostat=istat)line
			ll=icharlen(line)
			if (istat.lt.0) exit
			if(line(1:ls).eq.subline_id(1:ls).and.line(ls+1:ls+1).eq.'=')then
				read(line(ls+2:ll),*)val
				lline=icharlen(val)
				get_input_list_string=.true.
				iend=1
				exit
			endif
			j=j+1
		enddo
	endif
	if (iend.eq.1)exit
	i=i+1
enddo

end function get_input_list_string
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_list_mult(line_id,subline_id,unit,val,lv)
!***************************************************************************************************
implicit none
character*(*)				:: line_id,subline_id
character					:: test
character*256				:: line,dummy
integer						:: i,j,iend,ll,l,ls,unit,istat,lv
real						:: val(lv)

l=icharlen(line_id)
ls=icharlen(subline_id)

get_input_list_mult=.false.
i=1
iend=0
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		do
			read(unit,FMT='(A)',iostat=istat)test ! Look for blank lines to end list 
			if (len_trim(test).eq.0)then
				iend=1
				exit
			endif
			backspace(unit)
			read(unit,*,iostat=istat)line
			ll=icharlen(line)
			if (istat.lt.0) exit
			if(line(1:ls).eq.subline_id(1:ls).and.line(ls+1:ls+1).eq.'=')then
				read(line(ls+2:ll),*)val(1)
				backspace(unit)
				read(unit,*)dummy,val(2:lv)
				get_input_list_mult=.true.
				iend=1
				exit
			endif
			j=j+1
		enddo
	endif
	if (iend.eq.1)exit
	i=i+1
enddo

end function get_input_list_mult
!***************************************************************************************************


!***************************************************************************************************
   logical function get_input_list_mult_int(line_id,subline_id,unit,val,lv)
!***************************************************************************************************
implicit none
character*(*)				:: line_id,subline_id
character					:: test
character*256				:: line,dummy
integer						:: i,j,iend,ll,l,ls,unit,istat,lv
integer						:: val(lv)

l=icharlen(line_id)
ls=icharlen(subline_id)

get_input_list_mult_int=.false.
i=1
iend=0
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		do
			read(unit,FMT='(A)',iostat=istat)test ! Look for blank lines to end list 
			if (len_trim(test).eq.0)then
				iend=1
				exit
			endif
			backspace(unit)
			read(unit,*,iostat=istat)line
			ll=icharlen(line)
			if (istat.lt.0) exit
			if(line(1:ls).eq.subline_id(1:ls).and.line(ls+1:ls+1).eq.'=')then
				read(line(ls+2:ll),*)val(1)
				backspace(unit)
				read(unit,*)dummy,val(2:lv)
				get_input_list_mult_int=.true.
				iend=1
				exit
			endif
			j=j+1
		enddo
	endif
	if (iend.eq.1)exit
	i=i+1
enddo

end function get_input_list_mult_int
!***************************************************************************************************


!***************************************************************************************************
   logical function find_tag(line_id,unit)
!***************************************************************************************************
implicit none
character*(*)				:: line_id
character*256				:: line
integer						:: i,ll,l,unit,istat

l=icharlen(line_id)

find_tag=.false.
i=1
rewind(unit)
do
	read(unit,*,iostat=istat)line
	ll=icharlen(line)
	if (istat.lt.0) exit
	if(line(1:l).eq.line_id(1:l).and.line(l+1:l+1).eq.'=')then
		find_tag=.true.
		backspace(unit)
		exit
	endif
	i=i+1
enddo

end function find_tag
!***************************************************************************************************


!***************************************************************************************************
   subroutine init_char_null(string)
!***************************************************************************************************
implicit none
character*(*)   :: string
character*1     :: null
integer					   :: i


null=char(0)      
do i=1,len(string)
	string(i:i)=null(1:1)
enddo      
return 

end subroutine init_char_null
!***************************************************************************************************


!***************************************************************************************************
   integer function icharlen(string)
!***************************************************************************************************
implicit none
character*1 null
character*(*) string
integer					   :: i,j,k


null=char(0)
k=len(string)
do 10 i=1,k
	j=k+1-i
	if(string(j:j).eq.' '.or.string(j:j).eq.null) goto 10
	icharlen=j
	goto 99
 10 continue
icharlen=0
 99 return
end function icharlen
!***************************************************************************************************
   	 
  	  
end module io_lib
