!***************************************************************************************************
!
!   error_lib.f90
!      contains subroutines for computing confidence intervals and error ellipses.
!
!   Written by J.P. Verdon, University of Bristol, 2011.
!
!-------------------------------------------------------------------------------
!  This software is distributed in the hope that it will be useful, but WITHOUT
!  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
!  FITNESS FOR A PARTICULAR PURPOSE.
!
!  This software is distributed for ACADEMIC PURPOSES and is not to be 
!  distributed to any other parties.  This code is NOT TO BE INTEGRATED 
!  within or developed into COMMERCIAL CODE unless WRITTEN PERMISSION 
!  is given by the authors.
!-------------------------------------------------------------------------------
!
!     Last edited: March 2011
!
!***************************************************************************************************


!***************************************************************************************************
   subroutine error_norm(mf,mfnorm,npts,ngrid,conf,nvar)
! Mf is the 1D misfit surface
! Mfnorm is output - the normalised misfit surface
! npts is the number of 
! ngrid is the number of points on the misfit surface
! conf is the desired confidence interval
! nvar is the number of variables used in fitting
!***************************************************************************************************
integer i,npts,nvar,ngrid,nmt
real mf(ngrid),mfnorm(ngrid),conf
real chi_min,f,chi_max
	  
chi_min=minval(mf)
call f_test(npts,conf,nvar,f)
chi_max=chi_min*(1+(nvar*f)*(conf)/(npts-nvar))
do i=1,ngrid
	mfnorm(i)=mf(i)/chi_max
enddo
	  
return
end subroutine error_norm
!***************************************************************************************************


!***************************************************************************************************
   subroutine minimum_error_gs(mfnorm,err,nd,ngrid,steps,ranges)
!***************************************************************************************************

implicit none

integer i,j,ngrid,nd
integer,dimension(nd)		:: steps,model
real						:: e
real,dimension(nd)			:: err,emin,emax
real,dimension(2,nd)		:: ranges
real,dimension(ngrid)		:: mfnorm

! Initialise minimum and maximum
do i=1,nd
	emin(i)=1e24
	emax(i)=0
enddo

do i=1,ngrid
	if (mfnorm(i).le.1.0)then
		model(5)=1+mod(i-1,steps(5))
		model(4)=1+int((i-int((i-1)/(steps(5)*steps(4))) * (steps(5)*steps(4))-model(5))/steps(5))
		model(3)=1+int(((1+mod(i-1,steps(5)*steps(4)*steps(3)))-1)/(steps(5)*steps(4)))
		model(2)=1+int(((1+mod(i-1,steps(5)*steps(4)*steps(3)*steps(2)))-1)/(steps(5)*steps(4)*steps(3)))
		model(1)=1+int((i-1)/(steps(5)*steps(4)*steps(3)*steps(2)))
		
		do j=1,nd
			e=ranges(1,j)+(model(j)-1)*(ranges(2,j)-ranges(1,j))/(steps(j)-1)
			emin(j)=min(emin(j),e)
			emax(j)=max(emax(j),e)
		enddo
	endif
enddo
do j=1,nd
	err(j) = (emax(j)-emin(j))/2
enddo
	  
return
end subroutine minimum_error_gs
!***************************************************************************************************


!***************************************************************************************************
   subroutine f_test(npts,conf,nvar,f)
! F test data from: http://www.itl.nist.gov/div898/handbook/eda/section3/eda3673.htm
!***************************************************************************************************
integer i,npts,nvar
real f,conf
real,dimension(10)	:: ft11,ft12,ft13,ft14,ft15,ft16,ft17,ft18,ft19,ft10
real,dimension(10)	:: ft21,ft22,ft23,ft24,ft25,ft26,ft27,ft28,ft29,ft20
real,dimension(10)	:: ft31,ft32,ft33,ft34,ft35,ft36,ft37,ft38,ft39,ft30
real,dimension(10)	:: ft41,ft42,ft43,ft44,ft45,ft46,ft47,ft48,ft49,ft40
real,dimension(10)	:: ft51,ft52,ft53,ft54,ft55,ft56,ft57,ft58,ft59,ft50
real,dimension(10)	:: ft61,ft62,ft63,ft64,ft65,ft66,ft67,ft68,ft69,ft60
real,dimension(10)	:: ft71,ft72,ft73,ft74,ft75,ft76,ft77,ft78,ft79,ft70
real,dimension(10)	:: ft81,ft82,ft83,ft84,ft85,ft86,ft87,ft88,ft89,ft80
real,dimension(10)	:: ft91,ft92,ft93,ft94,ft95,ft96,ft97,ft98,ft99,ft90
real,dimension(10)	:: ft101,ft102,ft103,ft104,ft105,ft106,ft107,ft108,ft109,ft100
real,dimension(10)	:: ft111,ft112,ft113,ft114,ft115,ft116,ft117,ft118,ft119,ft110
real,dimension(10)	:: ft121,ft122,ft123,ft124,ft125,ft126,ft127,ft128,ft129,ft120
real,dimension(10)	:: ft131,ft132,ft133,ft134,ft135,ft136,ft137,ft138,ft139,ft130
real,dimension(10)	:: ft141,ft142,ft143,ft144,ft145,ft146,ft147,ft148,ft149,ft140
real,dimension(10)	:: ft151,ft152,ft153,ft154,ft155,ft156,ft157,ft158,ft159,ft150


real,dimension(100)	:: ftable1,ftable2,ftable3,ftable4,ftable5,ftable6,ftable7,ftable8
real,dimension(100)	:: ftable9,ftable10,ftable11,ftable12,ftable13,ftable14,ftable15

! Check that confidence interval is 90, 95 or 99%
if (conf.ne.0.99.and.conf.ne.0.95.and.conf.ne.0.9)then
	write(6,*)'Error in f_test: '
	write(6,*)'Confidence interval is not 90%, 95% or 99%'
	write(6,*)' confidence = ',conf
	write(6,*)'No F values available'
	stop
endif

data ft11 / 161.448, 18.513, 10.128, 7.709, 6.608,5.987, 5.591, 5.318, 5.117, 4.965 /
data ft12 / 4.844, 4.747, 4.667,4.6, 4.543,4.494, 4.451, 4.414, 4.381, 4.351 /
data ft13 / 4.325, 4.301, 4.279, 4.26 , 4.242,4.225, 4.21 , 4.196, 4.183, 4.171 /
data ft14 / 4.16 , 4.149, 4.139, 4.13 , 4.121,4.113, 4.105, 4.098, 4.091, 4.085 /
data ft15 /4.079, 4.073, 4.067, 4.062, 4.057,4.052, 4.047, 4.043, 4.038, 4.034 /
data ft16 / 4.03 , 4.027, 4.023, 4.02 , 4.016,4.013, 4.01 , 4.007, 4.004, 4.001 /
data ft17 /3.998, 3.996, 3.993, 3.991, 3.989,3.986, 3.984, 3.982, 3.98 , 3.978 /
data ft18 /3.976, 3.974, 3.972, 3.97 , 3.968,3.967, 3.965, 3.963, 3.962, 3.96 /
data ft19 /3.959, 3.957, 3.956, 3.955, 3.953,3.952, 3.951, 3.949, 3.948, 3.947 /
data ft10 /3.946, 3.945, 3.943, 3.942, 3.941,3.94 , 3.939, 3.938, 3.937, 3.087 /
ftable1(1:10)=ft11
ftable1(11:20)=ft12
ftable1(21:30)=ft13
ftable1(31:40)=ft14
ftable1(41:50)=ft15
ftable1(51:60)=ft16
ftable1(61:70)=ft17
ftable1(71:80)=ft18
ftable1(81:90)=ft19
ftable1(91:100)=ft10

data ft21 /39.863, 8.526, 5.538, 4.545, 4.06,3.776, 3.589, 3.458, 3.36 , 3.285/
data ft22 /3.225, 3.177, 3.136, 3.102, 3.073,3.048, 3.026, 3.007, 2.99 , 2.975/
data ft23 /2.961, 2.949, 2.937, 2.927, 2.918,2.909, 2.901, 2.894, 2.887, 2.881/
data ft24 /2.875, 2.869, 2.864, 2.859, 2.855,2.85 , 2.846, 2.842, 2.839, 2.835/
data ft25 /2.832, 2.829, 2.826, 2.823, 2.82 ,2.818, 2.815, 2.813, 2.811, 2.809/
data ft26 /2.807, 2.805, 2.803, 2.801, 2.799,2.797, 2.796, 2.794, 2.793, 2.791/
data ft27 /2.79 , 2.788, 2.787, 2.786, 2.784,2.783, 2.782, 2.781, 2.78 , 2.779/
data ft28 /2.778, 2.777, 2.776, 2.775, 2.774,2.773, 2.772, 2.771, 2.77 , 2.769/
data ft29 /2.769, 2.768, 2.767, 2.766, 2.765,2.765, 2.764, 2.763, 2.763, 2.762/
data ft20 /2.761, 2.761, 2.76 , 2.76 , 2.759,2.759, 2.758, 2.757, 2.757, 2.356 /
ftable2(1:10)=ft21
ftable2(11:20)=ft22
ftable2(21:30)=ft23
ftable2(31:40)=ft24
ftable2(41:50)=ft25
ftable2(51:60)=ft26
ftable2(61:70)=ft27
ftable2(71:80)=ft28
ftable2(81:90)=ft29
ftable2(91:100)=ft20	

data ft31 /199.500, 19.000, 9.552, 6.944,5.786, 5.143, 4.737,  4.459,  4.256,  4.103/		
data ft32 /	3.982,  3.885,  3.806,  3.739,  3.682,3.634,  3.592,  3.555,  3.522,  3.493/
data ft33 /	3.467,  3.443,  3.422,  3.403,  3.385,3.369,  3.354,  3.340,  3.328,  3.316/
data ft34 /	3.305,  3.295,  3.285,  3.276,  3.267,3.259,  3.252,  3.245,  3.238,  3.232/
data ft35 /	3.226,  3.220,  3.214,  3.209,  3.204,3.200,  3.195,  3.191,  3.187,  3.183/
data ft36 /	3.179,  3.175,  3.172,  3.168,  3.165,3.162,  3.159,  3.156,  3.153,  3.150/
data ft37 /	3.148,  3.145,  3.143,  3.140,  3.138,3.136,  3.134,  3.132,  3.130,  3.128/
data ft38 /	3.126,  3.124,  3.122,  3.120,  3.119,3.117,  3.115,  3.114,  3.112,  3.111/
data ft39 /	3.109,  3.108,  3.107,  3.105,  3.104,3.103,  3.101,  3.100,  3.099,  3.098/
data ft30 /	3.097,  3.095,  3.094,  3.093,  3.092,3.091,  3.090,  3.089,  3.088,  3.087 /
ftable3(1:10)=ft31
ftable3(11:20)=ft32
ftable3(21:30)=ft33
ftable3(31:40)=ft34
ftable3(41:50)=ft35
ftable3(51:60)=ft36
ftable3(61:70)=ft37
ftable3(71:80)=ft38
ftable3(81:90)=ft39
ftable3(91:100)=ft30


data ft41 /	49.5, 9, 5.462, 4.325, 3.78, 3.463,	3.257, 3.113, 3.006, 2.924/
data ft42 /	2.86,  2.807,2.763, 2.726, 2.695, 2.668, 2.645,2.624, 2.606, 2.589/
data ft43 /	2.575, 2.561, 2.549,2.538, 2.528, 2.519, 2.511, 2.503, 2.495,2.489/
data ft44 /	2.482, 2.477, 2.471, 2.466, 2.461,2.456, 2.452, 2.448, 2.444, 2.44 /
data ft45 /	2.437,2.434, 2.43 , 2.427, 2.425, 2.422, 2.419,2.417, 2.414, 2.412/
data ft46 /	2.41 , 2.408, 2.406,2.404, 2.402, 2.4  , 2.398, 2.396, 2.395,2.393/
data ft47 /	2.392, 2.39 , 2.389, 2.387, 2.386,2.385, 2.384, 2.382, 2.381, 2.38 /
data ft48 /	 2.379,2.378, 2.377, 2.376, 2.375, 2.374, 2.373,2.372, 2.371, 2.37 /
data ft49 /	2.369, 2.368, 2.368,2.367, 2.366, 2.365, 2.365, 2.364, 2.363,2.363/
data ft40 /	2.362, 2.361, 2.361, 2.36 , 2.359,2.359, 2.358, 2.358, 2.357, 2.139 /
ftable4(1:10)=ft41
ftable4(11:20)=ft42
ftable4(21:30)=ft43
ftable4(31:40)=ft44
ftable4(41:50)=ft45
ftable4(51:60)=ft46
ftable4(61:70)=ft47
ftable4(71:80)=ft48
ftable4(81:90)=ft49
ftable4(91:100)=ft40

data ft51 /215.707, 19.164, 9.277, 6.591, 5.409,4.757, 4.347, 4.066, 3.863, 3.708/		
data ft52 /	3.587, 3.49 , 3.411, 3.344, 3.287,3.239, 3.197, 3.16 , 3.127, 3.098/
data ft53 /	3.072, 3.049, 3.028, 3.009, 2.991,2.975, 2.96 , 2.947, 2.934, 2.922/
data ft54 /	2.911, 2.901, 2.892, 2.883, 2.874,2.866, 2.859, 2.852, 2.845, 2.839/
data ft55 /	2.833, 2.827, 2.822, 2.816, 2.812,2.807, 2.802, 2.798, 2.794, 2.79 /
data ft56 /	2.786, 2.783, 2.779, 2.776, 2.773,2.769, 2.766, 2.764, 2.761, 2.758/
data ft57 /	2.755, 2.753, 2.751, 2.748, 2.746,2.744, 2.742, 2.74 , 2.737, 2.736/
data ft58 /	2.734, 2.732, 2.73 , 2.728, 2.727,2.725, 2.723, 2.722, 2.72 , 2.719/
data ft59 /	2.717, 2.716, 2.715, 2.713, 2.712,2.711, 2.709, 2.708, 2.707, 2.706/
data ft50 /	2.705, 2.704, 2.703, 2.701, 2.7 ,2.699, 2.698, 2.697, 2.696, 2.463 /
ftable5(1:10)=ft51
ftable5(11:20)=ft52
ftable5(21:30)=ft53
ftable5(31:40)=ft54
ftable5(41:50)=ft55
ftable5(51:60)=ft56
ftable5(61:70)=ft57
ftable5(71:80)=ft58
ftable5(81:90)=ft59
ftable5(91:100)=ft50
 
data ft61 /	53.593, 9.162, 5.391, 4.191, 3.619,3.289, 3.074, 2.924, 2.813, 2.728/
data ft62 /	2.66 , 2.606, 2.56 , 2.522, 2.49 ,2.462, 2.437, 2.416, 2.397, 2.38 /
data ft63 /	2.365, 2.351, 2.339, 2.327, 2.317,2.307, 2.299, 2.291, 2.283, 2.276/
data ft64 /	2.27 , 2.263, 2.258, 2.252, 2.247,2.243, 2.238, 2.234, 2.23 , 2.226/
data ft65 /	2.222, 2.219, 2.216, 2.213, 2.21 ,2.207, 2.204, 2.202, 2.199, 2.197/
data ft66 /	2.194, 2.192, 2.19 , 2.188, 2.186,2.184, 2.182, 2.181, 2.179, 2.177/
data ft67 /	2.176, 2.174, 2.173, 2.171, 2.17 ,2.169, 2.167, 2.166, 2.165, 2.164/
data ft68 /	2.163, 2.161, 2.16 , 2.159, 2.158,2.157, 2.156, 2.155, 2.154, 2.154/
data ft69 /	2.153, 2.152, 2.151, 2.15 , 2.149,2.149, 2.148, 2.147, 2.146, 2.146/
data ft60 /	2.145, 2.144, 2.144, 2.143, 2.142,2.142, 2.141, 2.141, 2.14 , 2.002 /
ftable6(1:10)=ft61
ftable6(11:20)=ft62
ftable6(21:30)=ft63
ftable6(31:40)=ft64
ftable6(41:50)=ft65
ftable6(51:60)=ft66
ftable6(61:70)=ft67
ftable6(71:80)=ft68
ftable6(81:90)=ft69
ftable6(91:100)=ft60

data ft71 / 224.583,19.247, 9.117, 6.39,5.19,4.53,4.12,3.84,3.63,3.48/		
data ft72 /	3.36,3.26,3.18,3.11,3.06,3.01,2.97,2.93,2.90,2.87/
data ft73 /	2.84,2.82,2.80,2.78,2.76,2.74,2.73,2.71,2.70,2.69/
data ft74 /	2.68,2.67,2.66,2.65,2.64,2.63,2.63,2.62,2.61,2.61/
data ft75 /	2.60,2.59,2.59,2.58,2.58,2.57,2.57,2.57,2.56,2.56/
data ft76 /	2.55,2.55,2.55,2.54,2.54,2.54,2.53,2.53,2.53,2.53/
data ft77 /	2.52,2.52,2.52,2.52,2.51,2.51,2.51,2.51,2.51,2.50/
data ft78 /	2.50,2.50,2.50,2.50,2.49,2.49,2.49,2.49,2.49,2.49/
data ft79 /	2.48,2.48,2.48,2.48,2.48,2.48,2.48,2.48,2.47,2.47/
data ft70 /	2.47,2.47,2.47,2.47,2.47,2.47,2.47,2.47,2.46,2.46/
ftable7(1:10)=ft71
ftable7(11:20)=ft72
ftable7(21:30)=ft73
ftable7(31:40)=ft74
ftable7(41:50)=ft75
ftable7(51:60)=ft76
ftable7(61:70)=ft77
ftable7(71:80)=ft78
ftable7(81:90)=ft79
ftable7(91:100)=ft70

data ft81 /	55.833, 9.243, 5.343, 4.107,3.52,3.18,2.96,2.81,2.69,2.61/	
data ft82 / 2.54,2.48,2.43,2.40,2.36,2.33,2.31,2.29,2.27,2.25/	
data ft83 /	2.23,2.22,2.21,2.20,2.18,2.17,2.17,2.16,2.15,2.14/
data ft84 /	2.14,2.13,2.12,2.12,2.11,2.11,2.10,2.10,2.10,2.09/
data ft85 /	2.09,2.08,2.08,2.08,2.07,2.07,2.07,2.07,2.06,2.06/
data ft86 /	2.06,2.06,2.05,2.05,2.05,2.05,2.05,2.04,2.04,2.04/
data ft87 /	2.04,2.04,2.04,2.04,2.03,2.03,2.03,2.03,2.03,2.03/
data ft88 /	2.03,2.03,2.02,2.02,2.02,2.02,2.02,2.02,2.02,2.02/
data ft89 /	2.02,2.02,2.01,2.01,2.01,2.01,2.01,2.01,2.01,2.01/
data ft80 /	2.01,2.01,2.01,2.01,2.01,2.00,2.00,2.00,2.00,2.00/
ftable8(1:10)=ft81
ftable8(11:20)=ft82
ftable8(21:30)=ft83
ftable8(31:40)=ft84
ftable8(41:50)=ft85
ftable8(51:60)=ft86
ftable8(61:70)=ft87
ftable8(71:80)=ft88
ftable8(81:90)=ft89
ftable8(91:100)=ft80

data ft91 / 230.162,19.296,9.013,6.256,5.050,4.387,3.972,3.687,3.482,3.326 /		
data ft92 / 3.204,3.106,3.025,2.958,2.901,2.852,2.810,2.773,2.740,2.711 /
data ft93 / 2.685,2.661,2.640,2.621,2.603,2.587,2.572,2.558,2.545,2.534 /
data ft94 /	2.523,2.512,2.503,2.494,2.485,2.477,2.470,2.463,2.456,2.449 /
data ft95 /	2.443,2.438,2.432,2.427,2.422,2.417,2.413,2.409,2.404,2.400 /
data ft96 / 2.397,2.393,2.389,2.386,2.383,2.380,2.377,2.374,2.371,2.368 /
data ft97 / 2.366,2.363,2.361,2.358,2.356,2.354,2.352,2.350,2.348,2.346 /
data ft98 /	2.344,2.342,2.340,2.338,2.337,2.335,2.333,2.332,2.330,2.329 /
data ft99 /	2.327,2.326,2.324,2.323,2.322,2.321,2.319,2.318,2.317,2.316 /
data ft90 /	2.315,2.313,2.312,2.311,2.310,2.309,2.308,2.307,2.306,2.305 /
ftable9(1:10)=ft91
ftable9(11:20)=ft92
ftable9(21:30)=ft93
ftable9(31:40)=ft94
ftable9(41:50)=ft95
ftable9(51:60)=ft96
ftable9(61:70)=ft97
ftable9(71:80)=ft98
ftable9(81:90)=ft99
ftable9(91:100)=ft90

data ft101 / 57.240,9.293,5.309,4.051,3.453,3.108,2.883,2.726,2.611,2.522 /
data ft102 / 2.451,2.394,2.347,2.307,2.273,2.244,2.218,2.196,2.176,2.158 /
data ft103 / 2.142,2.128,2.115,2.103,2.092,2.082,2.073,2.064,2.057,2.049 /
data ft104 / 2.042,2.036,2.030,2.024,2.019,2.014,2.009,2.005,2.001,1.997 /
data ft105 / 1.993,1.989,1.986,1.983,1.980,1.977,1.974,1.971,1.968,1.966 /
data ft106 / 1.964,1.961,1.959,1.957,1.955,1.953,1.951,1.949,1.947,1.946 /
data ft107 / 1.944,1.942,1.941,1.939,1.938,1.937,1.935,1.934,1.933,1.931 /
data ft108 / 1.930,1.929,1.928,1.927,1.926,1.925,1.924,1.923,1.922,1.921 /
data ft109 / 1.920,1.919,1.918,1.917,1.916,1.915,1.915,1.914,1.913,1.912 /
data ft100 / 1.912,1.911,1.910,1.910,1.909,1.908,1.908,1.907,1.906,1.906 /
ftable10(1:10)=ft101
ftable10(11:20)=ft102
ftable10(21:30)=ft103
ftable10(31:40)=ft104
ftable10(41:50)=ft105
ftable10(51:60)=ft106
ftable10(61:70)=ft107
ftable10(71:80)=ft108
ftable10(81:90)=ft109
ftable10(91:100)=ft100

data ft111 /4052.19,98.502,34.116,21.198,16.258,13.745,12.246,11.259,10.561,10.044 /
data ft112 /9.646,9.33,9.074,8.862,8.683,8.531,8.4,8.285,8.185,8.096 /
data ft113 /8.017,7.945,7.881,7.823,7.77,7.721,7.677,7.636,7.598,7.562 /
data ft114 /7.53,7.499,7.471,7.444,7.419,7.396,7.373,7.353,7.333,7.314 /
data ft115 /7.296,7.28,7.264,7.248,7.234,7.22,7.207,7.194,7.182,7.171 /
data ft116 /7.159,7.149,7.139,7.129,7.119,7.11,7.102,7.093,7.085,7.077 /
data ft117 /7.07,7.062,7.055,7.048,7.042,7.035,7.029,7.023,7.017,7.011 /
data ft118 /7.006,7.001,6.995,6.99,6.985,6.981,6.976,6.971,6.967,6.963 /
data ft119 /6.958,6.954,6.95,6.947,6.943,6.939,6.935,6.932,6.928,6.925 /
data ft110 /6.922,6.919,6.915,6.912,6.909,6.906,6.904,6.901,6.898,6.895 /
ftable11(1:10)=ft111
ftable11(11:20)=ft112
ftable11(21:30)=ft113
ftable11(31:40)=ft114
ftable11(41:50)=ft115
ftable11(51:60)=ft116
ftable11(61:70)=ft117
ftable11(71:80)=ft118
ftable11(81:90)=ft119
ftable11(91:100)=ft110

data ft121 /4999.52,99,30.816,18,13.274,10.925,9.547,8.649,8.022,7.559 /
data ft122 /7.206,6.927,6.701,6.515,6.359,6.226,6.112,6.013,5.926,5.849 /
data ft123 /5.78,5.719,5.664,5.614,5.568,5.526,5.488,5.453,5.42,5.39 /
data ft124 /5.362,5.336,5.312,5.289,5.268,5.248,5.229,5.211,5.194,5.179 /
data ft125 /5.163,5.149,5.136,5.123,5.11,5.099,5.087,5.077,5.066,5.057 /
data ft126 /5.047,5.038,5.03,5.021,5.013,5.006,4.998,4.991,4.984,4.977 /
data ft127 /4.971,4.965,4.959,4.953,4.947,4.942,4.937,4.932,4.927,4.922 /
data ft128 /4.917,4.913,4.908,4.904,4.9,4.896,4.892,4.888,4.884,4.881 /
data ft129 /4.877,4.874,4.87,4.867,4.864,4.861,4.858,4.855,4.852,4.849 /
data ft120 /4.846,4.844,4.841,4.838,4.836,4.833,4.831,4.829,4.826,4.824 /
ftable12(1:10)=ft121
ftable12(11:20)=ft122
ftable12(21:30)=ft123
ftable12(31:40)=ft124
ftable12(41:50)=ft125
ftable12(51:60)=ft126
ftable12(61:70)=ft127
ftable12(71:80)=ft128
ftable12(81:90)=ft129
ftable12(91:100)=ft120

data ft131 /5403.34,99.166,29.457,16.694,12.06,9.78,8.451,7.591,6.992,6.552/
data ft132 /6.217,5.953,5.739,5.564,5.417,5.292,5.185,5.092,5.01,4.938 /
data ft133 /4.874,4.817,4.765,4.718,4.675,4.637,4.601,4.568,4.538,4.51 /
data ft134 /4.484,4.459,4.437,4.416,4.396,4.377,4.36,4.343,4.327,4.313 /
data ft135 /4.299,4.285,4.273,4.261,4.249,4.238,4.228,4.218,4.208,4.199 /
data ft136 /4.191,4.182,4.174,4.167,4.159,4.152,4.145,4.138,4.132,4.126 /
data ft137 /4.12,4.114,4.109,4.103,4.098,4.093,4.088,4.083,4.079,4.074 /
data ft138 /4.07,4.066,4.062,4.058,4.054,4.05,4.047,4.043,4.04,4.036 /
data ft139 /4.033,4.03,4.027,4.024,4.021,4.018,4.015,4.012,4.01,4.007 /
data ft130 /4.004,4.002,3.999,3.997,3.995,3.992,3.99,3.988,3.986,3.984 /
ftable13(1:10)=ft131
ftable13(11:20)=ft132
ftable13(21:30)=ft133
ftable13(31:40)=ft134
ftable13(41:50)=ft135
ftable13(51:60)=ft136
ftable13(61:70)=ft137
ftable13(71:80)=ft138
ftable13(81:90)=ft139
ftable13(91:100)=ft130

data ft141 /5624.62,99.249,28.71,15.977,11.392,9.148,7.847,7.006,6.422,5.994 /
data ft142 /5.668,5.412,5.205,5.035,4.893,4.773,4.669,4.579,4.5,4.431 /
data ft143 /4.369,4.313,4.264,4.218,4.177,4.14,4.106,4.074,4.045,4.018 /
data ft144 /3.993,3.969,3.948,3.927,3.908,3.89,3.873,3.858,3.843,3.828 /
data ft145 /3.815,3.802,3.79,3.778,3.767,3.757,3.747,3.737,3.728,3.72 /
data ft146 /3.711,3.703,3.695,3.688,3.681,3.674,3.667,3.661,3.655,3.649 /
data ft147 /3.643,3.638,3.632,3.627,3.622,3.618,3.613,3.608,3.604,3.6 /
data ft148 /3.596,3.591,3.588,3.584,3.58,3.577,3.573,3.57,3.566,3.563 /
data ft149 /3.56,3.557,3.554,3.551,3.548,3.545,3.543,3.54,3.538,3.535 /
data ft140 /3.533,3.53,3.528,3.525,3.523,3.521,3.519,3.517,3.515,3.513 /
ftable14(1:10)=ft141
ftable14(11:20)=ft142
ftable14(21:30)=ft143
ftable14(31:40)=ft144
ftable14(41:50)=ft145
ftable14(51:60)=ft146
ftable14(61:70)=ft147
ftable14(71:80)=ft148
ftable14(81:90)=ft149
ftable14(91:100)=ft140

data ft151 /5763.65,99.3,28.237,15.522,10.967,8.746,7.46,6.632,6.057,5.636 /
data ft152 /5.316,5.064,4.862,4.695,4.556,4.437,4.336,4.248,4.171,4.103 /
data ft153 /4.042,3.988,3.939,3.895,3.855,3.818,3.785,3.754,3.725,3.699 /
data ft154 /3.675,3.652,3.63,3.611,3.592,3.574,3.558,3.542,3.528,3.514 /
data ft155 /3.501,3.488,3.476,3.465,3.454,3.444,3.434,3.425,3.416,3.408 /
data ft156 /3.4,3.392,3.384,3.377,3.37,3.363,3.357,3.351,3.345,3.339 /
data ft157 /3.333,3.328,3.323,3.318,3.313,3.308,3.304,3.299,3.295,3.291 /
data ft158 /3.287,3.283,3.279,3.275,3.272,3.268,3.265,3.261,3.258,3.255 /
data ft159 /3.252,3.249,3.246,3.243,3.24,3.238,3.235,3.233,3.23,3.228 /
data ft150 /3.225,3.223,3.221,3.218,3.216,3.214,3.212,3.21,3.208,3.206 /
ftable15(1:10)=ft151
ftable15(11:20)=ft152
ftable15(21:30)=ft153
ftable15(31:40)=ft154
ftable15(41:50)=ft155
ftable15(51:60)=ft156
ftable15(61:70)=ft157
ftable15(71:80)=ft158
ftable15(81:90)=ft159
ftable15(91:100)=ft150

if (nvar.eq.1) then
	if (conf.eq.0.95) then
		if (npts.gt.100)then
			f=ftable1(100)
		else
			f=ftable1(npts)
		endif
	elseif (conf.eq.0.9) then
		if (npts.gt.100)then
			f=ftable2(100)
		else
			f=ftable2(npts)
		endif
	elseif (conf.eq.0.99) then
		if (npts.gt.100)then
			f=ftable11(100)
		else
			f=ftable11(npts)
		endif
	else
		write(6,*)'Error in error library: confidence limit is not a recognised value (0.9, 0.95 or 0.99)'
		stop 'Ending program'
	endif
endif
if (nvar.eq.2) then
	if (conf.eq.0.95) then
		if (npts.gt.100)then
			f=ftable3(100)
		else
			f=ftable3(npts)
		endif
	elseif (conf.eq.0.9) then
		if (npts.gt.100)then
			f=ftable4(100)
		else
			f=ftable4(npts)
		endif
	elseif (conf.eq.0.99) then
		if (npts.gt.100)then
			f=ftable12(100)
		else
			f=ftable12(npts)
		endif
	else
		write(6,*)'Error in error library: confidence limit is not a recognised value (0.9, 0.95 or 0.99)'
		stop 'Ending program'
	endif
endif
if (nvar.eq.3) then
if (conf.eq.0.95) then
		if (npts.gt.100)then
			f=ftable5(100)
		else
			f=ftable5(npts)
		endif
	elseif (conf.eq.0.9) then
		if (npts.gt.100)then
			f=ftable6(100)
		else
			f=ftable6(npts)
		endif
	elseif (conf.eq.0.99) then
		if (npts.gt.100)then
			f=ftable13(100)
		else
			f=ftable13(npts)
		endif
	else
		write(6,*)'Error in error library: confidence limit is not a recognised value (0.9, 0.95 or 0.99)'
		stop 'Ending program'
	endif
endif
if (nvar.eq.4) then
if (conf.eq.0.95) then
		if (npts.gt.100)then
			f=ftable7(100)
		else
			f=ftable7(npts)
		endif
	elseif (conf.eq.0.9) then
		if (npts.gt.100)then
			f=ftable8(100)
		else
			f=ftable8(npts)
		endif
	elseif (conf.eq.0.99) then
		if (npts.gt.100)then
			f=ftable14(100)
		else
			f=ftable14(npts)
		endif
	else
		write(6,*)'Error in error library: confidence limit is not a recognised value (0.9, 0.95 or 0.99)'
		stop 'Ending program'
	endif
endif	
if (nvar.eq.5) then
if (conf.eq.0.95) then
		if (npts.gt.100)then
			f=ftable9(100)
		else
			f=ftable9(npts)
		endif
	elseif (conf.eq.0.9) then
		if (npts.gt.100)then
			f=ftable10(100)
		else
			f=ftable10(npts)
		endif
	elseif (conf.eq.0.99) then
		if (npts.gt.100)then
			f=ftable15(100)
		else
			f=ftable15(npts)
		endif
	else
		write(6,*)'Error in error library: confidence limit is not a recognised value (0.9, 0.95 or 0.99)'
		stop 'Ending program'
	endif
endif	
		
return
end subroutine f_test
!***************************************************************************************************
